/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.testRemote;

import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import hep.aida.ref.remote.testRemote.TestUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class AidaTreeClientTest
implements AidaTreeClient {
    private Map hash;
    private IDevMutableStore store;
    private boolean duplex;
    public static long serverUpdateInterval;
    private boolean connected;
    private Thread thread;
    private boolean keepRunning;
    private String nodeType = "RemoteManagedObjectTest";

    public AidaTreeClientTest(IDevMutableStore store) {
        this(store, true);
    }

    public AidaTreeClientTest(IDevMutableStore store, boolean duplex) {
        this(store, duplex, -1L);
    }

    public AidaTreeClientTest(IDevMutableStore store, boolean duplex, long serverUpdateInterval) {
        this.store = store;
        this.duplex = duplex;
        AidaTreeClientTest.serverUpdateInterval = serverUpdateInterval;
        this.initTestClient();
    }

    public void initTestClient() {
        this.connected = false;
        if (this.hash != null) {
            this.hash.clear();
        } else {
            this.hash = new Hashtable();
        }
        this.keepRunning = true;
        if (this.duplex && serverUpdateInterval > 0L) {
            this.startUpdateThread();
        }
    }

    public void startUpdateThread() {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (AidaTreeClientTest.this.keepRunning) {
                    try {
                        Thread.sleep(serverUpdateInterval);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Map map = AidaTreeClientTest.this.hash;
                    synchronized (map) {
                        if (!AidaTreeClientTest.this.hash.isEmpty()) {
                            int size = AidaTreeClientTest.this.hash.size();
                            AidaUpdateEvent[] events = new AidaUpdateEvent[size];
                            int i = 0;
                            Iterator it = AidaTreeClientTest.this.hash.keySet().iterator();
                            while (it.hasNext()) {
                                String path = (String)it.next();
                                events[i] = new RemoteUpdateEvent(0, path, AidaTreeClientTest.this.nodeType);
                                ++i;
                            }
                            AidaTreeClientTest.this.stateChanged(events);
                        }
                    }
                }
            }
        });
        this.thread.start();
    }

    public boolean connect() throws RemoteConnectionException {
        if (this.connected) {
            throw new RemoteConnectionException("Already connected, please disconnect first!");
        }
        this.connected = true;
        return this.connected;
    }

    public boolean disconnect() {
        serverUpdateInterval = 1L;
        this.keepRunning = false;
        this.connected = false;
        if (this.hash != null) {
            this.hash.clear();
        }
        this.hash = null;
        this.thread = null;
        return true;
    }

    public Object find(String path) throws IllegalArgumentException {
        Object obj = TestUtils.find(path);
        this.hash.put(path, obj);
        return obj;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String[] listObjectNames(String path) throws IllegalArgumentException {
        return TestUtils.listObjectNames(path);
    }

    public String[] listObjectTypes(String path) throws IllegalArgumentException {
        return TestUtils.listObjectTypes(path);
    }

    public void stateChanged(AidaUpdateEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            String path = events[i].path();
            String type = events[i].nodeType();
            this.store.updateData(path, type);
        }
    }
}

