/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.testRemote;

import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import hep.aida.ref.remote.testRemote.TestUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class AidaTreeServantTest
implements AidaTreeServant {
    private Map hash;
    private AidaTreeClient client;
    private boolean duplex;
    public static long serverUpdateInterval;
    private boolean connected;
    private Thread thread;
    private boolean keepRunning;
    private String nodeType = "RemoteManagedObjectTest";

    public AidaTreeServantTest(AidaTreeClient client) {
        this(client, true);
    }

    public AidaTreeServantTest(AidaTreeClient client, boolean duplex) {
        this(client, duplex, -1L);
    }

    public AidaTreeServantTest(AidaTreeClient client, boolean duplex, long serverUpdateInterval) {
        this.client = client;
        this.duplex = duplex;
        AidaTreeServantTest.serverUpdateInterval = serverUpdateInterval;
        this.initServantTest();
    }

    public void initServantTest() {
        this.connected = false;
        if (this.hash != null) {
            this.hash.clear();
        } else {
            this.hash = new Hashtable();
        }
        this.keepRunning = true;
        if (this.duplex && serverUpdateInterval > 0L) {
            this.startUpdateThread();
        }
    }

    public void startUpdateThread() {
        this.thread = new Thread(new Runnable(){

            public void run() {
                while (AidaTreeServantTest.this.duplex && AidaTreeServantTest.this.keepRunning) {
                    try {
                        Thread.sleep(serverUpdateInterval);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    AidaUpdateEvent[] events = AidaTreeServantTest.this.createUpdateEvents();
                    AidaTreeServantTest.this.client.stateChanged(events);
                }
            }
        });
        this.thread.start();
    }

    public boolean disconnect() {
        serverUpdateInterval = 1L;
        this.keepRunning = false;
        this.connected = false;
        if (this.hash != null) {
            this.hash.clear();
        }
        this.hash = null;
        this.thread = null;
        this.client = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AidaUpdateEvent[] createUpdateEvents() {
        AidaUpdateEvent[] events = null;
        Map map = this.hash;
        synchronized (map) {
            if (!this.hash.isEmpty()) {
                int size = this.hash.size();
                events = new AidaUpdateEvent[size];
                int i = 0;
                Iterator it = this.hash.keySet().iterator();
                while (it.hasNext()) {
                    String path = (String)it.next();
                    events[i] = new RemoteUpdateEvent(0, path, this.nodeType);
                    ++i;
                }
            }
        }
        return events;
    }

    public Object find(String path) {
        Object obj = TestUtils.find(path);
        this.hash.put(path, obj);
        return obj;
    }

    public String[] listObjectNames(String path) {
        return TestUtils.listObjectNames(path);
    }

    public String[] listObjectTypes(String path) {
        return TestUtils.listObjectTypes(path);
    }

    public void setValid(String[] nodePaths) {
    }

    public AidaUpdateEvent[] updates() {
        AidaUpdateEvent[] events = this.createUpdateEvents();
        return events;
    }
}

