/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.testRemote;

import hep.aida.IManagedObject;
import hep.aida.ref.remote.RemoteClient;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteMutableStore;
import hep.aida.ref.remote.interfaces.AidaTreeServer;
import hep.aida.ref.remote.testRemote.RemoteClientTest;
import hep.aida.ref.remote.testRemote.converters.TestConverter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class RemoteMutableStoreTest
extends RemoteMutableStore {
    private Map converters;
    private AidaTreeServer testServer;

    public RemoteMutableStoreTest() {
        this((AidaTreeServer)null);
    }

    public RemoteMutableStoreTest(AidaTreeServer testServer) {
        this.init();
        this.testServer = testServer;
    }

    public void init() {
        super.init();
        this.converters = new Hashtable();
    }

    protected RemoteClient createClient(Map options) {
        RemoteClientTest client = null;
        String clientType = "AidaTreeClientTest";
        boolean duplex = true;
        long serverUpdateInterval = -1L;
        if (options == null) {
            throw new IllegalArgumentException("No information about AidaTreeServer, options NULL");
        }
        Iterator it = options.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = ((String)options.get(key)).trim();
            System.out.println("Key = " + key + " \tValue = " + value);
            try {
                if (key.equalsIgnoreCase("serverUpdateInterval")) {
                    serverUpdateInterval = Long.parseLong(value);
                    continue;
                }
                if (key.equalsIgnoreCase("clientType")) {
                    clientType = value;
                    continue;
                }
                if (!key.equalsIgnoreCase("duplex")) continue;
                if (value.equalsIgnoreCase("true")) {
                    duplex = true;
                    continue;
                }
                duplex = false;
            }
            catch (Exception e) {
                System.out.println("Can not parce options: Key=" + key + "\tValue = " + value + ", will use defaults");
                e.printStackTrace();
            }
        }
        if (clientType.equalsIgnoreCase("RemoteClientTest")) {
            client = new RemoteClientTest(this, duplex, this.testServer, serverUpdateInterval);
        }
        return client;
    }

    public IManagedObject createObject(String name, String aidaType) throws IllegalArgumentException {
        TestConverter converter = this.findConverter(aidaType);
        IManagedObject mo = (IManagedObject)converter.createAidaObject(name);
        if (mo instanceof RemoteManagedObject) {
            ((RemoteManagedObject)mo).setStore(this);
        }
        return mo;
    }

    public void updateData(String path, String aidaType) throws IllegalArgumentException {
        TestConverter converter = this.findConverter(aidaType);
        IManagedObject mo = this.tree.find(path);
        Object data = this.client.find(path);
        converter.updateAidaObject(mo, data);
        if (mo instanceof RemoteManagedObject) {
            ((RemoteManagedObject)mo).setDataValid(true);
        }
    }

    public void close() throws IOException {
        super.close();
        this.converters.clear();
        this.converters = null;
    }

    private TestConverter findConverter(String aidaType) {
        TestConverter converter = null;
        if (this.converters.containsKey(aidaType)) {
            converter = (TestConverter)this.converters.get(aidaType);
        } else {
            Lookup.Template template = new Lookup.Template(TestConverter.class, aidaType, null);
            Lookup.Item item = FreeHEPLookup.instance().lookupItem(template);
            if (item == null) {
                throw new IllegalArgumentException("No Converter for AIDA Type: " + aidaType);
            }
            converter = (TestConverter)item.getInstance();
            this.converters.put(aidaType, converter);
        }
        return converter;
    }
}

