/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.testRemote.converters;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IHistogram2D;
import hep.aida.IManagedObject;
import hep.aida.ref.Annotation;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.remote.RemoteHistogram2D;
import hep.aida.ref.remote.testRemote.converters.TestConverter;

public final class TestHist2DConverter
extends TestConverter {
    private static TestHist2DConverter converter = null;

    public static TestHist2DConverter getInstance() {
        if (converter == null) {
            converter = new TestHist2DConverter();
        }
        return converter;
    }

    private TestHist2DConverter() {
        this.dataType = "IHistogram2D";
        this.aidaType = "IHistogram2D";
    }

    public Object createAidaObject(String name) {
        RemoteHistogram2D result = new RemoteHistogram2D(name);
        return result;
    }

    public boolean updateAidaObject(Object aidaObject, Object newData) {
        IHistogram2D data = null;
        if (newData instanceof IHistogram2D) {
            data = (IHistogram2D)newData;
        }
        if (!(aidaObject instanceof RemoteHistogram2D)) {
            throw new IllegalArgumentException("Not supported object type: " + aidaObject.getClass().getName());
        }
        if (!(data instanceof IHistogram2D)) {
            throw new IllegalArgumentException("Not supported data type: " + (data == null ? "null" : newData.getClass().getName()));
        }
        this.updateData((RemoteHistogram2D)aidaObject, data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractData(Object aidaObject) {
        if (!(aidaObject instanceof IHistogram2D)) {
            throw new IllegalArgumentException("Not supported data type: " + aidaObject.getClass().getName());
        }
        IHistogram2D data = null;
        Object object = aidaObject;
        synchronized (object) {
            data = this.createData((IHistogram2D)aidaObject);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedObject updateData(RemoteHistogram2D hist, IHistogram2D data) {
        hist.setFillable(true);
        IAnnotation localAnnotation = null;
        int inRangeEntries = 0;
        int extraEntries = 0;
        double equivalentBinEntries = 0.0;
        double inRangeBinHeights = 0.0;
        double extraBinHeights = 0.0;
        double minBinHeights = 0.0;
        double maxBinHeights = 0.0;
        int[][] entries = null;
        double[][] heights = null;
        double[][] errors = null;
        double[][] rmss = null;
        double[][] meansX = null;
        double[][] rmssX = null;
        double[][] meansY = null;
        double[][] rmssY = null;
        int[] binEntriesX = null;
        int[] binEntriesY = null;
        double[] binHeightsX = null;
        double[] binHeightsY = null;
        IHistogram2D iHistogram2D = data;
        synchronized (iHistogram2D) {
            IAxis lXAxis = hist.xAxis();
            IAxis rXAxis = data.xAxis();
            int nXBins = rXAxis.bins();
            if (lXAxis == null || lXAxis.bins() != nXBins || lXAxis.lowerEdge() != rXAxis.lowerEdge() || lXAxis.upperEdge() != rXAxis.upperEdge()) {
                hist.setXAxis(nXBins, rXAxis.lowerEdge(), rXAxis.upperEdge());
            }
            IAxis lYAxis = hist.yAxis();
            IAxis rYAxis = data.yAxis();
            int nYBins = rYAxis.bins();
            if (lYAxis == null || lXAxis.bins() != nYBins || lYAxis.lowerEdge() != rYAxis.lowerEdge() || lYAxis.upperEdge() != rYAxis.upperEdge()) {
                hist.setYAxis(nYBins, rYAxis.lowerEdge(), rYAxis.upperEdge());
            }
            if (data.annotation() != null && data.annotation().size() > 0) {
                boolean sticky = false;
                localAnnotation = hist.annotation();
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(true);
                }
                for (int i = 0; i < data.annotation().size(); ++i) {
                    String key = data.annotation().key(i);
                    String newValue = data.annotation().value(key);
                    String oldValue = null;
                    try {
                        oldValue = localAnnotation.value(key);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (oldValue == null) {
                        localAnnotation.addItem(key, newValue, sticky);
                        continue;
                    }
                    if (newValue.equals(oldValue)) continue;
                    localAnnotation.setValue(key, newValue);
                    localAnnotation.setSticky(key, sticky);
                }
                if (localAnnotation instanceof Annotation) {
                    ((Annotation)localAnnotation).setFillable(false);
                }
            }
            if (nXBins > 0 && nYBins > 0) {
                int i;
                entries = new int[nXBins + 2][nYBins + 2];
                heights = new double[nXBins + 2][nYBins + 2];
                errors = new double[nXBins + 2][nYBins + 2];
                meansX = new double[nXBins + 2][nYBins + 2];
                rmssX = new double[nXBins + 2][nYBins + 2];
                meansY = new double[nXBins + 2][nYBins + 2];
                rmssY = new double[nXBins + 2][nYBins + 2];
                binEntriesX = new int[nXBins + 2];
                binEntriesY = new int[nYBins + 2];
                binHeightsX = new double[nXBins + 2];
                binHeightsY = new double[nYBins + 2];
                int ii = 0;
                int jj = 0;
                for (i = 0; i < nXBins + 2; ++i) {
                    for (int j = 0; j < nYBins + 2; ++j) {
                        ii = this.convertToAIDAIndex(nXBins, i);
                        jj = this.convertToAIDAIndex(nYBins, j);
                        heights[i][j] = data.binHeight(ii, jj);
                        errors[i][j] = data.binError(ii, jj);
                        entries[i][j] = data.binEntries(ii, jj);
                        meansX[i][j] = data.binMeanX(ii, jj);
                        meansY[i][j] = data.binMeanY(ii, jj);
                        if (!(data instanceof Histogram2D)) continue;
                        rmssX[i][j] = ((Histogram2D)data).binRmsX(ii, jj);
                        rmssY[i][j] = ((Histogram2D)data).binRmsY(ii, jj);
                    }
                }
                for (i = 0; i < nXBins + 2; ++i) {
                    ii = this.convertToAIDAIndex(nXBins, i);
                    binEntriesX[i] = data.binEntriesX(ii);
                    binHeightsX[i] = data.binHeightX(ii);
                }
                for (int j = 0; j < nYBins + 2; ++j) {
                    jj = this.convertToAIDAIndex(nYBins, j);
                    binEntriesY[j] = data.binEntriesX(jj);
                    binHeightsY[j] = data.binHeightX(jj);
                }
                inRangeEntries = data.entries();
                extraEntries = data.extraEntries();
                equivalentBinEntries = data.equivalentBinEntries();
                inRangeBinHeights = data.sumBinHeights();
                extraBinHeights = data.sumExtraBinHeights();
                minBinHeights = data.minBinHeight();
                maxBinHeights = data.maxBinHeight();
            }
        }
        iHistogram2D = hist;
        synchronized (iHistogram2D) {
            hist.setHeights(heights);
            hist.setErrors(errors);
            hist.setEntries(entries);
            hist.setBinMeansX(meansX);
            hist.setBinRmssX(rmssX);
            hist.setBinMeansY(meansY);
            hist.setBinRmssY(rmssY);
            hist.setBinEntriesX(binEntriesX);
            hist.setBinEntriesY(binEntriesY);
            hist.setBinHeightsX(binHeightsX);
            hist.setBinHeightsX(binHeightsY);
            hist.setMeanX(data.meanX());
            hist.setRmsX(data.rmsX());
            hist.setMeanY(data.meanY());
            hist.setRmsY(data.rmsY());
            hist.setInRangeEntries(inRangeEntries);
            hist.setExtraEntries(extraEntries);
            hist.setEquivalentBinEntries(equivalentBinEntries);
            hist.setInRangeBinHeights(inRangeBinHeights);
            hist.setExtraBinHeights(extraBinHeights);
            hist.setMinBinHeights(minBinHeights);
            hist.setMaxBinHeights(maxBinHeights);
            hist.setFillable(false);
            hist.setDataValid(true);
        }
        return hist;
    }

    public IHistogram2D createData(IHistogram2D hist) {
        IHistogram2D data = hist;
        return data;
    }

    private int convertToAIDAIndex(int nBins, int index) {
        int mi = index == 0 ? -2 : (index == nBins + 1 ? -1 : index - 1);
        return mi;
    }
}

