/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IFunction;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.IMeasurement;
import hep.aida.IModelFunction;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.IRangeSet;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ref.Annotation;
import hep.aida.ref.histogram.Cloud;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.Histogram3D;
import hep.aida.ref.histogram.VariableAxis;
import hep.aida.ref.tuple.AbstractTuple;
import hep.aida.ref.tuple.Tuple;
import java.io.IOException;
import java.io.Writer;
import org.freehep.xml.util.XMLWriter;

class AidaXMLWriter
extends XMLWriter {
    static /* synthetic */ Class class$hep$aida$ITuple;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    AidaXMLWriter(Writer writer) throws IOException {
        super(writer);
        this.openDoc("1.0", "ISO-8859-1", false);
        this.referToDTD("aida", "http://aida.freehep.org/schemas/3.2.1/aida.dtd");
        this.setAttribute("version", "3.2.1");
        this.openTag("aida");
        this.setAttribute("package", "FreeHEP");
        this.setAttribute("version", "1.1");
        this.printTag("implementation");
    }

    public void close() throws IOException {
        this.closeTag();
        super.close();
    }

    private String binNumbToString(int bin) {
        if (bin == -2) {
            return "UNDERFLOW";
        }
        if (bin == -1) {
            return "OVERFLOW";
        }
        return String.valueOf(bin);
    }

    void toXML(ITree tree) {
        String[] objNames = tree.listObjectNames("/", true);
        for (int i = 0; i < objNames.length; ++i) {
            int pos = objNames[i].lastIndexOf(47);
            if (pos + 1 == objNames[i].length()) continue;
            this.toXML(tree.find(objNames[i]), objNames[i].substring(0, pos + 1));
        }
    }

    private void toXML(IManagedObject o, String path) {
        if (o instanceof IHistogram1D) {
            this.toXML((IHistogram1D)o, path);
        } else if (o instanceof IHistogram2D) {
            this.toXML((IHistogram2D)o, path);
        } else if (o instanceof IHistogram3D) {
            this.toXML((IHistogram3D)o, path);
        } else if (o instanceof ICloud1D) {
            this.toXML((ICloud1D)o, path);
        } else if (o instanceof ICloud2D) {
            this.toXML((ICloud2D)o, path);
        } else if (o instanceof ICloud3D) {
            this.toXML((ICloud3D)o, path);
        } else if (o instanceof ITuple) {
            this.toXML((ITuple)o, path);
        } else if (o instanceof IDataPointSet) {
            this.toXML((IDataPointSet)o, path);
        } else if (o instanceof IProfile1D) {
            this.toXML((IProfile1D)o, path);
        } else if (o instanceof IProfile2D) {
            this.toXML((IProfile2D)o, path);
        } else if (o instanceof IFunction) {
            this.toXML((IFunction)o, path);
        }
    }

    private void toXML(IHistogram1D h, String path) {
        String name = ((IManagedObject)h).name();
        this.setAttribute("name", name);
        String title = h.title();
        if (title != null && title != null && !title.equals("")) {
            this.setAttribute("title", title);
        }
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        this.openTag("histogram1d");
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.axis(), "x");
        this.setAttribute("entries", h.entries());
        this.openTag("statistics");
        this.setAttribute("direction", "x");
        this.setAttribute("mean", h.mean());
        this.setAttribute("rms", h.rms());
        this.printTag("statistic");
        this.closeTag();
        this.openTag("data1d");
        int bins = h.axis().bins();
        for (int i = -2; i < h.axis().bins(); ++i) {
            double height = h.binHeight(i);
            double error = h.binError(i);
            if (height == 0.0 || error == 0.0) continue;
            this.setAttribute("binNum", this.binNumbToString(i));
            if (h instanceof Histogram1D) {
                this.setAttribute("weightedMean", ((Histogram1D)h).binMean(i));
                this.setAttribute("weightedRms", ((Histogram1D)h).binRms(i));
            }
            this.setAttribute("height", height);
            this.setAttribute("error", error);
            this.setAttribute("entries", h.binEntries(i));
            this.printTag("bin1d");
        }
        this.closeTag();
        this.closeTag();
    }

    private void toXML(IHistogram2D h, String path) {
        String name = ((IManagedObject)h).name();
        this.setAttribute("name", name);
        String title = h.title();
        if (title != null && !title.equals("")) {
            this.setAttribute("title", title);
        }
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        this.openTag("histogram2d");
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.xAxis(), "x");
        this.writeHistogramAxis(h.yAxis(), "y");
        this.setAttribute("entries", h.entries());
        this.openTag("statistics");
        this.setAttribute("direction", "x");
        this.setAttribute("mean", h.meanX());
        this.setAttribute("rms", h.rmsX());
        this.printTag("statistic");
        this.setAttribute("direction", "y");
        this.setAttribute("mean", h.meanY());
        this.setAttribute("rms", h.rmsY());
        this.printTag("statistic");
        this.closeTag();
        this.openTag("data2d");
        int xbins = h.xAxis().bins();
        int ybins = h.yAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            for (int j = -2; j < ybins; ++j) {
                double height = h.binHeight(i, j);
                double error = h.binError(i, j);
                if (height == 0.0 || error == 0.0) continue;
                this.setAttribute("binNumX", this.binNumbToString(i));
                this.setAttribute("binNumY", this.binNumbToString(j));
                if (h instanceof Histogram2D) {
                    this.setAttribute("weightedMeanX", ((Histogram2D)h).binMeanX(i, j));
                    this.setAttribute("weightedMeanY", ((Histogram2D)h).binMeanY(i, j));
                    this.setAttribute("weightedRmsX", ((Histogram2D)h).binRmsX(i, j));
                    this.setAttribute("weightedRmsY", ((Histogram2D)h).binRmsY(i, j));
                }
                this.setAttribute("height", height);
                this.setAttribute("error", error);
                this.setAttribute("entries", h.binEntries(i, j));
                this.printTag("bin2d");
            }
        }
        this.closeTag();
        this.closeTag();
    }

    private void toXML(IHistogram3D h, String path) {
        String name = ((IManagedObject)h).name();
        this.setAttribute("name", name);
        String title = h.title();
        if (title != null && !title.equals("")) {
            this.setAttribute("title", title);
        }
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        this.openTag("histogram3d");
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.xAxis(), "x");
        this.writeHistogramAxis(h.yAxis(), "y");
        this.writeHistogramAxis(h.zAxis(), "z");
        this.setAttribute("entries", h.entries());
        this.openTag("statistics");
        this.setAttribute("direction", "x");
        this.setAttribute("mean", h.meanX());
        this.setAttribute("rms", h.rmsX());
        this.printTag("statistic");
        this.setAttribute("direction", "y");
        this.setAttribute("mean", h.meanY());
        this.setAttribute("rms", h.rmsY());
        this.printTag("statistic");
        this.setAttribute("direction", "z");
        this.setAttribute("mean", h.meanZ());
        this.setAttribute("rms", h.rmsZ());
        this.printTag("statistic");
        this.closeTag();
        this.openTag("data3d");
        int xbins = h.xAxis().bins();
        int ybins = h.yAxis().bins();
        int zbins = h.zAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            for (int j = -2; j < ybins; ++j) {
                for (int k = -2; k < zbins; ++k) {
                    double height = h.binHeight(i, j, k);
                    double error = h.binError(i, j, k);
                    if (height == 0.0 || error == 0.0) continue;
                    this.setAttribute("binNumX", this.binNumbToString(i));
                    this.setAttribute("binNumY", this.binNumbToString(j));
                    this.setAttribute("binNumZ", this.binNumbToString(k));
                    if (h instanceof Histogram3D) {
                        this.setAttribute("weightedMeanX", ((Histogram3D)h).binMeanX(i, j, k));
                        this.setAttribute("weightedMeanY", ((Histogram3D)h).binMeanY(i, j, k));
                        this.setAttribute("weightedMeanZ", ((Histogram3D)h).binMeanZ(i, j, k));
                        this.setAttribute("weightedRmsX", ((Histogram3D)h).binRmsX(i, j, k));
                        this.setAttribute("weightedRmsY", ((Histogram3D)h).binRmsY(i, j, k));
                        this.setAttribute("weightedRmsZ", ((Histogram3D)h).binRmsZ(i, j, k));
                    }
                    this.setAttribute("height", height);
                    this.setAttribute("error", error);
                    this.setAttribute("entries", h.binEntries(i, j, k));
                    this.printTag("bin3d");
                }
            }
        }
        this.closeTag();
        this.closeTag();
    }

    private void toXML(ICloud1D c, String path) {
        String options;
        this.setAttribute("name", ((IManagedObject)c).name());
        this.setAttribute("maxEntries", ((Cloud)c).maxEntries());
        String title = c.title();
        if (title != null && !title.equals("")) {
            this.setAttribute("title", title);
        }
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        if ((options = ((Cloud)c).getOptions()) != null && !options.equals("")) {
            this.setAttribute("options", options);
        }
        IHistogram1D hist = null;
        try {
            hist = c.histogram();
            this.setAttribute("lowerEdgeX", c.lowerEdge());
            this.setAttribute("upperEdgeX", c.upperEdge());
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        this.openTag("cloud1d");
        IAnnotation annotation = c.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        if (hist != null) {
            this.toXML(hist, path);
        } else {
            this.openTag("entries1d");
            for (int i = 0; i < c.entries(); ++i) {
                this.setAttribute("valueX", c.value(i));
                double w = c.weight(i);
                if (w != 1.0) {
                    this.setAttribute("weight", w);
                }
                this.printTag("entry1d");
            }
            this.closeTag();
        }
        this.closeTag();
    }

    private void toXML(ICloud2D c, String path) {
        String options;
        this.setAttribute("name", ((IManagedObject)c).name());
        this.setAttribute("maxEntries", ((Cloud)c).maxEntries());
        String title = c.title();
        if (title != null && !title.equals("")) {
            this.setAttribute("title", title);
        }
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        if ((options = ((Cloud)c).getOptions()) != null && !options.equals("")) {
            this.setAttribute("options", options);
        }
        IHistogram2D hist = null;
        try {
            hist = c.histogram();
            this.setAttribute("lowerEdgeX", c.lowerEdgeX());
            this.setAttribute("upperEdgeX", c.upperEdgeX());
            this.setAttribute("lowerEdgeY", c.lowerEdgeY());
            this.setAttribute("upperEdgeY", c.upperEdgeY());
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        this.openTag("cloud2d");
        IAnnotation annotation = c.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        if (hist != null) {
            this.toXML(hist, path);
        } else {
            this.openTag("entries2d");
            for (int i = 0; i < c.entries(); ++i) {
                this.setAttribute("valueX", c.valueX(i));
                this.setAttribute("valueY", c.valueY(i));
                double w = c.weight(i);
                if (w != 1.0) {
                    this.setAttribute("weight", w);
                }
                this.printTag("entry2d");
            }
            this.closeTag();
        }
        this.closeTag();
    }

    private void toXML(ICloud3D c, String path) {
        String options;
        this.setAttribute("name", ((IManagedObject)c).name());
        this.setAttribute("maxEntries", ((Cloud)c).maxEntries());
        String title = c.title();
        if (title != null && !title.equals("")) {
            this.setAttribute("title", title);
        }
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        if ((options = ((Cloud)c).getOptions()) != null && !options.equals("")) {
            this.setAttribute("options", options);
        }
        IHistogram3D hist = null;
        try {
            hist = c.histogram();
            this.setAttribute("lowerEdgeX", c.lowerEdgeX());
            this.setAttribute("upperEdgeX", c.upperEdgeX());
            this.setAttribute("lowerEdgeY", c.lowerEdgeY());
            this.setAttribute("upperEdgeY", c.upperEdgeY());
            this.setAttribute("lowerEdgeZ", c.lowerEdgeZ());
            this.setAttribute("upperEdgeZ", c.upperEdgeZ());
        }
        catch (RuntimeException re) {
            // empty catch block
        }
        this.openTag("cloud3d");
        IAnnotation annotation = c.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        if (hist != null) {
            this.toXML(hist, path);
        } else {
            this.openTag("entries3d");
            for (int i = 0; i < c.entries(); ++i) {
                this.setAttribute("valueX", c.valueX(i));
                this.setAttribute("valueY", c.valueY(i));
                this.setAttribute("valueZ", c.valueZ(i));
                double w = c.weight(i);
                if (w != 1.0) {
                    this.setAttribute("weight", w);
                }
                this.printTag("entry3d");
            }
            this.closeTag();
        }
        this.closeTag();
    }

    private void toXML(ITuple tuple, String path) {
        this.setAttribute("name", ((IManagedObject)tuple).name());
        this.setAttribute("title", tuple.title());
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        String options = null;
        if (tuple instanceof Tuple) {
            options = ((Tuple)tuple).getOptions();
        }
        if (options != null && !options.equals("")) {
            this.setAttribute("options", options);
        }
        int columns = tuple.columns();
        this.openTag("tuple");
        IAnnotation annotation = tuple.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.openTag("columns");
        for (int i = 0; i < columns; ++i) {
            Class colType = tuple.columnType(i);
            String def = null;
            if (tuple instanceof AbstractTuple) {
                def = ((AbstractTuple)tuple).columnDefaultString(i);
            }
            String tupName = tuple.columnName(i);
            if (def != null) {
                tupName = tupName + "=" + def;
            }
            if (colType == (class$hep$aida$ITuple == null ? AidaXMLWriter.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                tupName = def;
            }
            this.setAttribute("name", tupName);
            if (colType == (class$hep$aida$ITuple == null ? AidaXMLWriter.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                this.setAttribute("type", "ITuple");
            } else {
                this.setAttribute("type", (class$java$lang$String == null ? AidaXMLWriter.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(colType) ? "string" : colType.getName());
            }
            this.printTag("column");
        }
        this.closeTag();
        this.openTag("rows");
        this.writeTupleEntries(tuple);
        this.closeTag();
        this.closeTag();
    }

    private void toXML(IDataPointSet dps, String path) {
        this.setAttribute("name", ((IManagedObject)dps).name());
        this.setAttribute("title", dps.title());
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        this.setAttribute("dimension", dps.dimension());
        this.openTag("dataPointSet");
        IAnnotation annotation = dps.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        for (int i = 0; i < dps.size(); ++i) {
            IDataPoint point = dps.point(i);
            this.openTag("dataPoint");
            for (int j = 0; j < point.dimension(); ++j) {
                double em;
                IMeasurement m = point.coordinate(j);
                this.setAttribute("value", m.value());
                double ep = m.errorPlus();
                if (!Double.isNaN(ep)) {
                    this.setAttribute("errorPlus", ep);
                }
                if (!Double.isNaN(em = m.errorMinus())) {
                    this.setAttribute("errorMinus", em);
                }
                this.printTag("measurement");
            }
            this.closeTag();
        }
        this.closeTag();
    }

    private void toXML(IProfile1D h, String path) {
        String name = ((IManagedObject)h).name();
        this.setAttribute("name", name);
        String title = h.title();
        if (title != null && !title.equals("")) {
            this.setAttribute("title", title);
        }
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        this.openTag("profile1d");
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.axis(), "x");
        this.setAttribute("entries", h.entries());
        this.openTag("statistics");
        this.setAttribute("direction", "x");
        this.setAttribute("mean", h.mean());
        this.setAttribute("rms", h.rms());
        this.printTag("statistic");
        this.closeTag();
        this.openTag("data1d");
        int bins = h.axis().bins();
        for (int i = -2; i < h.axis().bins(); ++i) {
            double height = h.binHeight(i);
            double error = h.binError(i);
            if (height == 0.0 || error == 0.0) continue;
            this.setAttribute("binNum", this.binNumbToString(i));
            this.setAttribute("weightedMean", h.binMean(i));
            this.setAttribute("rms", h.binRms(i));
            this.setAttribute("height", height);
            this.setAttribute("error", error);
            this.setAttribute("entries", h.binEntries(i));
            this.printTag("bin1d");
        }
        this.closeTag();
        this.closeTag();
    }

    private void toXML(IProfile2D h, String path) {
        String name = ((IManagedObject)h).name();
        this.setAttribute("name", name);
        String title = h.title();
        if (title != null && !title.equals("")) {
            this.setAttribute("title", title);
        }
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        this.openTag("profile2d");
        IAnnotation annotation = h.annotation();
        if (annotation != null) {
            this.toXML(annotation);
        }
        this.writeHistogramAxis(h.xAxis(), "x");
        this.writeHistogramAxis(h.yAxis(), "y");
        this.setAttribute("entries", h.entries());
        this.openTag("statistics");
        this.setAttribute("direction", "x");
        this.setAttribute("mean", h.meanX());
        this.setAttribute("rms", h.rmsX());
        this.printTag("statistic");
        this.setAttribute("direction", "y");
        this.setAttribute("mean", h.meanY());
        this.setAttribute("rms", h.rmsY());
        this.printTag("statistic");
        this.closeTag();
        this.openTag("data2d");
        int xbins = h.xAxis().bins();
        int ybins = h.yAxis().bins();
        for (int i = -2; i < xbins; ++i) {
            for (int j = -2; j < ybins; ++j) {
                double height = h.binHeight(i, j);
                double error = h.binError(i, j);
                if (height == 0.0 || error == 0.0) continue;
                this.setAttribute("binNumX", this.binNumbToString(i));
                this.setAttribute("binNumY", this.binNumbToString(j));
                this.setAttribute("weightedMeanX", h.binMeanX(i, j));
                this.setAttribute("weightedMeanY", h.binMeanY(i, j));
                this.setAttribute("rms", h.binRms(i, j));
                this.setAttribute("height", height);
                this.setAttribute("error", error);
                this.setAttribute("entries", h.binEntries(i, j));
                this.printTag("bin2d");
            }
        }
        this.closeTag();
        this.closeTag();
    }

    private void toXML(IAnnotation annotation) {
        this.openTag("annotation");
        for (int i = 0; i < annotation.size(); ++i) {
            String key = annotation.key(i);
            this.setAttribute("key", key);
            this.setAttribute("value", annotation.value(key));
            if (annotation instanceof Annotation) {
                this.setAttribute("sticky", String.valueOf(((Annotation)annotation).isSticky(key)));
            }
            this.printTag("item");
        }
        this.closeTag();
    }

    private void writeHistogramAxis(IAxis axis, String direction) {
        this.setAttribute("direction", direction);
        this.setAttribute("min", axis.lowerEdge());
        this.setAttribute("max", axis.upperEdge());
        this.setAttribute("numberOfBins", axis.bins());
        if (axis instanceof VariableAxis) {
            this.openTag("axis");
            for (int i = 0; i < axis.bins() - 1; ++i) {
                this.setAttribute("value", axis.binUpperEdge(i));
                this.printTag("binBorder");
            }
            this.closeTag();
        } else {
            this.printTag("axis");
        }
    }

    private void writeTupleEntries(ITuple tup) {
        tup.start();
        for (int j = 0; j < tup.rows(); ++j) {
            tup.next();
            this.openTag("row");
            for (int i = 0; i < tup.columns(); ++i) {
                Class colType = tup.columnType(i);
                String vStr = "value";
                if (colType == (class$hep$aida$ITuple == null ? AidaXMLWriter.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                    ITuple tupp = (ITuple)tup.getObject(i);
                    if (tupp == null) {
                        this.printTag("entryITuple");
                        continue;
                    }
                    this.openTag("entryITuple");
                    this.writeTupleEntries(tupp);
                    this.closeTag();
                    continue;
                }
                if (colType == Integer.TYPE) {
                    this.setAttribute(vStr, tup.getInt(i));
                } else if (colType == Short.TYPE) {
                    this.setAttribute(vStr, tup.getShort(i));
                } else if (colType == Long.TYPE) {
                    this.setAttribute(vStr, tup.getLong(i));
                } else if (colType == Float.TYPE) {
                    this.setAttribute(vStr, tup.getFloat(i));
                } else if (colType == Double.TYPE) {
                    this.setAttribute(vStr, tup.getDouble(i));
                } else if (colType == Boolean.TYPE) {
                    this.setAttribute(vStr, tup.getBoolean(i));
                } else if (colType == Byte.TYPE) {
                    this.setAttribute(vStr, tup.getByte(i));
                } else if (colType == Character.TYPE) {
                    this.setAttribute(vStr, tup.getChar(i));
                } else if (colType == (class$java$lang$String == null ? AidaXMLWriter.class$("java.lang.String") : class$java$lang$String)) {
                    this.setAttribute(vStr, tup.getString(i));
                } else if (colType == (class$java$lang$Object == null ? AidaXMLWriter.class$("java.lang.Object") : class$java$lang$Object)) {
                    this.setAttribute(vStr, tup.getObject(i).toString());
                }
                this.printTag("entry");
            }
            this.closeTag();
        }
    }

    private void toXML(IFunction function, String path) {
        IModelFunction model = null;
        if (function instanceof IModelFunction) {
            model = (IModelFunction)function;
        }
        this.setAttribute("name", ((IManagedObject)function).name());
        this.setAttribute("title", function.title());
        if (path != null && !path.equals("")) {
            this.setAttribute("path", path);
        }
        if (model != null) {
            this.setAttribute("isNormalized", String.valueOf(model.isNormalized()));
        }
        this.openTag("function");
        this.openTag("codelet");
        this.println(function.codeletString());
        this.closeTag();
        if (model != null) {
            this.openTag("arguments");
            for (int i = 0; i < function.dimension(); ++i) {
                this.setAttribute("name", model.variableName(i));
                this.openTag("argument");
                IRangeSet rangeSet = model.normalizationRange(i);
                double[] lb = rangeSet.lowerBounds();
                double[] ub = rangeSet.upperBounds();
                for (int j = 0; j < lb.length; ++j) {
                    this.setAttribute("min", lb[j]);
                    this.setAttribute("max", ub[j]);
                    this.printTag("range");
                }
                this.closeTag();
            }
            this.closeTag();
        }
        this.openTag("parameters");
        String[] parNames = function.parameterNames();
        double[] parValues = function.parameters();
        for (int i = 0; i < function.numberOfParameters(); ++i) {
            this.setAttribute("name", parNames[i]);
            this.setAttribute("value", parValues[i]);
            this.printTag("parameter");
        }
        this.closeTag();
        this.closeTag();
    }
}

