/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.util.comparison;

import hep.aida.ext.IComparisonData;

public class ComparisonData
implements IComparisonData {
    private double[] data;
    private double[] weight;
    private int type;
    private int[] entries;

    public ComparisonData(double[] data, double[] weight, int type) {
        this(data, weight, null, type);
    }

    public ComparisonData(double[] data, double[] weight, int[] entries, int type) {
        if (data.length != weight.length || entries != null && data.length != entries.length) {
            throw new IllegalArgumentException("Incompatible lengths! Data and weights have different lengths.");
        }
        this.data = data;
        this.weight = weight;
        this.type = type;
        this.entries = entries;
    }

    public int nPoints() {
        return this.data.length;
    }

    public int type() {
        return this.type;
    }

    public double value(int i) {
        return this.data[i];
    }

    public double weight(int i) {
        return this.weight[i];
    }

    public int entries(int i) {
        if (this.entries == null) {
            return 1;
        }
        return this.entries[i];
    }
}

