/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.RootObject;
import hep.io.root.daemon.RootAuthenticator;
import hep.io.root.daemon.RootURLStreamFactory;
import hep.io.root.interfaces.TH1;
import hep.io.root.interfaces.TKey;
import hep.io.root.util.RootDirectoryTreeCellRenderer;
import hep.io.root.util.RootHistogramAdapter;
import hep.io.root.util.RootHistogramTreeModel;
import jas.hist.DataSource;
import jas.hist.JASHist;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RootHistogramBrowser
extends JPanel
implements TreeSelectionListener {
    private static final String aboutMessage = "<HTML>RootHistogramBrowser $Id: RootHistogramBrowser.java,v 1.2 2004/06/28 15:21:26 tonyj Exp $<br>Author: Tony Johnson (tonyj@slac.stanford.edu)";
    private static final TreeModel emptyTree = null;
    private JASHist plot;
    private JTree tree = new JTree(emptyTree);

    RootHistogramBrowser() throws IOException {
        super(new BorderLayout());
        this.tree.setCellRenderer(new RootDirectoryTreeCellRenderer());
        this.tree.addTreeSelectionListener(this);
        this.tree.setRootVisible(false);
        this.plot = new JASHist();
        this.plot.setBackground(Color.white);
        this.plot.setShowStatistics(true);
        JSplitPane split = new JSplitPane(1, new JScrollPane(this.tree), (Component)this.plot);
        this.add((Component)split, "Center");
        this.add((Component)new RootMenuBar(), "North");
        this.setPreferredSize(new Dimension(500, 300));
        split.setDividerLocation(245);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootFile(File file) throws IOException {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            RootFileReader reader = new RootFileReader(file);
            RootHistogramTreeModel model = new RootHistogramTreeModel(reader){

                public void handleException(IOException x) {
                    RootHistogramBrowser.this.error(x);
                    x.printStackTrace();
                    super.handleException(x);
                }
            };
            this.tree.setModel(model);
            this.tree.setRowHeight(20);
            this.tree.setLargeModel(true);
        }
        finally {
            this.setCursor(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootFile(URL url) throws IOException {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            RootFileReader reader = new RootFileReader(url);
            RootHistogramTreeModel model = new RootHistogramTreeModel(reader){

                public void handleException(IOException x) {
                    RootHistogramBrowser.this.error(x);
                    x.printStackTrace();
                    super.handleException(x);
                }
            };
            this.tree.setModel(model);
            this.tree.setRowHeight(20);
            this.tree.setLargeModel(true);
        }
        finally {
            this.setCursor(old);
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length > 1) {
            RootHistogramBrowser.usage();
        }
        if (argv.length == 1 && argv[0].startsWith("-")) {
            RootHistogramBrowser.usage();
        }
        URL.setURLStreamHandlerFactory(new RootURLStreamFactory());
        JFrame frame = new JFrame("Root Histogram Browser");
        RootHistogramBrowser browser = new RootHistogramBrowser();
        Authenticator.setDefault(new RootAuthenticator(browser));
        URLConnection.setDefaultAllowUserInteraction(true);
        if (argv.length == 1) {
            if (argv[0].startsWith("root:")) {
                browser.setRootFile(new URL(argv[0]));
            } else {
                browser.setRootFile(new File(argv[0]));
            }
        }
        frame.setContentPane(browser);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    private static void usage() {
        System.out.println("java RootHistogramBrowser [<file>]");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(TreeSelectionEvent event) {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            DataSource ds;
            TKey key;
            RootObject node;
            this.plot.removeAllData();
            TreePath path = this.tree.getSelectionPath();
            if (path != null && (node = (key = (TKey)path.getLastPathComponent()).getObject()) instanceof TH1 && (ds = RootHistogramAdapter.create((TH1)node)) != null) {
                this.plot.setTitle(ds.getTitle());
                this.plot.addData(ds).show(true);
            }
        }
        catch (IOException x) {
            x.printStackTrace();
            this.error(x);
        }
        catch (RootClassNotFound x) {
            x.printStackTrace();
            this.error(x);
        }
        finally {
            this.setCursor(old);
        }
    }

    private void error(Exception x) {
        JOptionPane.showMessageDialog(this, x.getMessage(), "Error", 0);
    }

    private static class RootFileFilter
    extends FileFilter {
        private RootFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".root");
        }

        public String getDescription() {
            return "Root Files (*.root)";
        }
    }

    private class RootHelpMenu
    extends JMenu {
        RootHelpMenu() {
            super("Help");
            this.add(new JMenuItem(this, "About...", RootHistogramBrowser.this){
                private final /* synthetic */ RootHistogramBrowser val$this$0;
                private final /* synthetic */ RootHelpMenu this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                public void fireActionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(RootHelpMenu.access$300(this.this$1), "<HTML>RootHistogramBrowser $Id: RootHistogramBrowser.java,v 1.2 2004/06/28 15:21:26 tonyj Exp $<br>Author: Tony Johnson (tonyj@slac.stanford.edu)");
                }
            });
        }

        static /* synthetic */ RootHistogramBrowser access$300(RootHelpMenu x0) {
            return x0.RootHistogramBrowser.this;
        }
    }

    private class RootFileMenu
    extends JMenu {
        RootFileMenu() {
            super("File");
            this.add(new JMenuItem(this, "Open File...", RootHistogramBrowser.this){
                private final /* synthetic */ RootHistogramBrowser val$this$0;
                private final /* synthetic */ RootFileMenu this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                public void fireActionPerformed(ActionEvent e) {
                    JFileChooser dlg = null;
                    try {
                        if (System.getSecurityManager() != null && System.getProperty("os.name").indexOf("indows") > 0 && System.getProperty("java.version").startsWith("1.3")) {
                            dlg = new JFileChooser("Open Root File...");
                        }
                    }
                    catch (SecurityException x) {
                        // empty catch block
                    }
                    if (dlg == null) {
                        dlg = new JFileChooser("Open Root File...");
                    }
                    dlg.setFileFilter(new RootFileFilter());
                    int rc = dlg.showOpenDialog(RootFileMenu.access$200(this.this$1));
                    if (rc == 0) {
                        try {
                            RootFileMenu.access$200(this.this$1).setRootFile(dlg.getSelectedFile());
                        }
                        catch (IOException x) {
                            RootHistogramBrowser.access$000(RootFileMenu.access$200(this.this$1), x);
                        }
                    }
                }
            });
            this.add(new JMenuItem(this, "Open URL...", RootHistogramBrowser.this){
                private final /* synthetic */ RootHistogramBrowser val$this$0;
                private final /* synthetic */ RootFileMenu this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                public void fireActionPerformed(ActionEvent e) {
                    String url = JOptionPane.showInputDialog(RootFileMenu.access$200(this.this$1), "URL", "root://");
                    if (url != null) {
                        try {
                            RootFileMenu.access$200(this.this$1).setRootFile(new URL(url));
                        }
                        catch (IOException x) {
                            RootHistogramBrowser.access$000(RootFileMenu.access$200(this.this$1), x);
                        }
                    }
                }
            });
            this.add(new JMenuItem(this, "Exit"){
                private final /* synthetic */ RootFileMenu this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void fireActionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }

        static /* synthetic */ RootHistogramBrowser access$200(RootFileMenu x0) {
            return x0.RootHistogramBrowser.this;
        }
    }

    private class RootMenuBar
    extends JMenuBar {
        RootMenuBar() {
            this.add(new RootFileMenu());
            this.add(new RootHelpMenu());
        }
    }
}

