/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.interfaces.FTupleCursor;
import hep.tuple.interfaces.FillableTupleColumn;
import java.util.ArrayList;
import java.util.Map;
import org.freehep.util.OptionParser;
import org.freehep.util.Value;

public abstract class TupleColumn
implements FillableTupleColumn {
    protected Value defaultValue = null;
    protected ArrayList arrayList = new ArrayList();
    protected int arraySize;
    protected int maximumSize;
    protected int nStack;
    protected Object currentArray;
    protected int currentArrayIndex = -1;
    private boolean isOpenEnded;
    private int sizeOfLastCreatedArray;
    private int nFilled;
    private String columnName;
    private Class columnType;
    private double minValue;
    private double maxValue;
    private double meanValue;
    private double rmsValue;
    private Value colValue = new Value();
    private boolean hasDefaultValue = false;
    private int nNaN = 0;
    private boolean calculateStatistics = true;

    TupleColumn(String name, Class type, Value value, String options) {
        Map optionMap = OptionParser.parseOptions((String)options);
        int length = 1000;
        int maxLength = -1;
        if (optionMap.containsKey("length")) {
            length = Integer.parseInt((String)optionMap.get("length"));
        }
        if (optionMap.containsKey("maxlength")) {
            maxLength = Integer.parseInt((String)optionMap.get("maxlength"));
            if (!optionMap.containsKey("length")) {
                length = maxLength;
            }
        }
        if (optionMap.containsKey("calculatestatistics")) {
            this.calculateStatistics = Boolean.valueOf((String)optionMap.get("calculatestatistics"));
        }
        this.columnName = name;
        this.columnType = type;
        if (value != null) {
            if (value.getObject() != null && !type.isAssignableFrom(value.getType())) {
                throw new IllegalArgumentException("The default value's type " + value.getType() + " is incompatible with the TupleColumn's type " + type);
            }
            this.setDefaultValue(value);
            this.hasDefaultValue = true;
        }
        if (this.hasStatistics()) {
            this.minValue = Double.NaN;
            this.maxValue = Double.NaN;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Wrong length " + length + " it must be positive!");
        }
        this.arraySize = length;
        if (maxLength < 0) {
            this.isOpenEnded = true;
        } else if (maxLength >= length) {
            this.isOpenEnded = false;
        } else {
            throw new IllegalArgumentException("Wrong maximum length " + maxLength + " it cannot be smaller than the internal arraySize " + length);
        }
        this.maximumSize = maxLength;
        this.reset();
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    public String name() {
        return this.columnName;
    }

    public Class type() {
        return this.columnType;
    }

    public void value(FTupleCursor cursor, Value value) {
        this.value(cursor.row(), value);
    }

    public abstract void value(int var1, Value var2);

    public void fill(Value value) {
        this.setValue(this.nStack, value);
    }

    public abstract void setValue(int var1, Value var2);

    public void addRow() {
        if (this.calculateStatistics && this.hasStatistics()) {
            this.value(this.nStack, this.colValue);
            double v = this.colValue.getDouble();
            if (v < this.minValue || Double.isNaN(this.minValue)) {
                this.minValue = v;
            }
            if (v > this.maxValue || Double.isNaN(this.maxValue)) {
                this.maxValue = v;
            }
            if (!Double.isNaN(v)) {
                this.meanValue += v;
                this.rmsValue += v * v;
            } else {
                ++this.nNaN;
            }
        }
        this.nFilled = this.nStack++;
        int columnLength = this.getColumnLength();
        if (this.nStack == columnLength) {
            int spaceLeft;
            if (!this.isOpenEnded() && (spaceLeft = this.maximumSize - columnLength) < this.arraySize) {
                this.sizeOfLastCreatedArray = spaceLeft;
            }
            if (this.sizeOfLastCreatedArray > 0) {
                this.createArray(this.sizeOfLastCreatedArray);
            }
        }
    }

    public void resetRow() {
        if (this.hasDefaultValue()) {
            this.fill(this.getDefaultValue());
        }
    }

    public void reset() {
        this.arrayList.clear();
        this.sizeOfLastCreatedArray = this.arraySize;
        this.createArray(this.sizeOfLastCreatedArray);
        this.setCurrentArray(0);
        this.initTupleColumn();
    }

    public void minValue(Value value) {
        if (!this.hasStatistics() || this.nFilled < 0) {
            value.set(Double.NaN);
        } else {
            value.set(this.minValue);
        }
    }

    public void maxValue(Value value) {
        if (!this.hasStatistics() || this.nFilled < 0) {
            value.set(Double.NaN);
        } else {
            value.set(this.maxValue);
        }
    }

    public void meanValue(Value value) {
        if (!this.hasStatistics() || this.nFilled < 0) {
            value.set(Double.NaN);
        } else {
            value.set(this.meanValue / (double)(this.getFilledRows() - this.nNaN));
        }
    }

    public void rmsValue(Value value) {
        if (!this.hasStatistics() || this.nFilled < 0) {
            value.set(Double.NaN);
        } else {
            double rows = this.getFilledRows() - this.nNaN;
            value.set(Math.sqrt(this.rmsValue / rows - this.meanValue * this.meanValue / rows / rows));
        }
    }

    private void initTupleColumn() {
        this.nFilled = -1;
        this.nStack = 0;
        this.meanValue = 0.0;
        this.rmsValue = 0.0;
        this.nNaN = 0;
    }

    private int getColumnLength() {
        return this.arraySize * (this.arrayList.size() - 1) + this.sizeOfLastCreatedArray;
    }

    private int getFilledRows() {
        return this.nFilled + 1;
    }

    private boolean isOpenEnded() {
        return this.isOpenEnded;
    }

    protected abstract void createArray(int var1);

    protected Value getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(Value value) {
        this.defaultValue = new Value(value);
    }

    protected abstract boolean hasStatistics();

    protected void setCurrentArray(int index) {
        if (index < 0 || index > this.getFilledRows()) {
            String message = "Illegal cursor position. ";
            if (index < 0) {
                message = message + "next() has to be invoked after start() before accessing the data in the ITuple";
            }
            if (index > this.nFilled) {
                message = message + "Before accessing the data start() has to be invoked.";
            }
            throw new IllegalArgumentException(message);
        }
        int arrayIndex = index / this.arraySize;
        if (arrayIndex != this.currentArrayIndex) {
            this.currentArrayIndex = arrayIndex;
            this.currentArray = this.arrayList.get(this.currentArrayIndex);
            this.currentArrayUpdated();
        }
    }

    protected abstract void currentArrayUpdated();

    public void resetRows(int numberOfRows) {
        if (this.hasDefaultValue()) {
            this.fill(this.getDefaultValue());
        }
        while (numberOfRows-- > 0) {
            this.value(this.nFilled--, this.colValue);
            if (this.hasStatistics()) {
                double v = this.colValue.getDouble();
                if (Double.isNaN(v)) {
                    --this.nNaN;
                } else {
                    this.meanValue -= v;
                    this.rmsValue -= v * v;
                }
            }
            --this.nStack;
            if (!this.hasDefaultValue()) continue;
            this.fill(this.getDefaultValue());
        }
        if (this.hasStatistics()) {
            this.calculateMinMax();
        }
    }

    private void calculateMinMax() {
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        int rows = this.getFilledRows();
        for (int i = 0; i < rows; ++i) {
            this.value(i, this.colValue);
            double v = this.colValue.getDouble();
            if (v < this.minValue || Double.isNaN(this.minValue)) {
                this.minValue = v;
            }
            if (!(v > this.maxValue) && !Double.isNaN(this.maxValue)) continue;
            this.maxValue = v;
        }
    }
}

