/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.TupleColumn;
import org.freehep.util.Value;

public class TupleColumnDouble
extends TupleColumn {
    private double[] data;

    TupleColumnDouble(String name, Value value, String options) {
        super(name, Double.TYPE, value, options);
    }

    protected void createArray(int size) {
        double[] data = new double[size];
        if (this.hasDefaultValue()) {
            for (int i = 0; i < size; ++i) {
                data[i] = this.getDefaultValue().getDouble();
            }
        }
        this.arrayList.add(data);
    }

    public void value(int index, Value value) {
        this.setCurrentArray(index);
        value.set(this.data[index % this.arraySize]);
    }

    public void setValue(int index, Value value) {
        try {
            this.setCurrentArray(index);
            this.data[index % this.arraySize] = value.getDouble();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Wrong argument for TupleColumnDouble");
        }
    }

    protected boolean hasStatistics() {
        return true;
    }

    public void defaultValue(Value value) {
        if (this.hasDefaultValue()) {
            value.set(this.getDefaultValue().getDouble());
        }
    }

    protected void currentArrayUpdated() {
        this.data = (double[])this.currentArray;
    }
}

