/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.TupleColumn;
import org.freehep.util.Value;

public class TupleColumnFloat
extends TupleColumn {
    private float[] data;

    TupleColumnFloat(String name, Value value, String options) {
        super(name, Float.TYPE, value, options);
    }

    protected void createArray(int size) {
        float[] data = new float[size];
        if (this.hasDefaultValue()) {
            for (int i = 0; i < size; ++i) {
                data[i] = this.getDefaultValue().getFloat();
            }
        }
        this.arrayList.add(data);
    }

    public void value(int index, Value value) {
        this.setCurrentArray(index);
        value.set(this.data[index % this.arraySize]);
    }

    public void setValue(int index, Value value) {
        try {
            this.setCurrentArray(index);
            this.data[index % this.arraySize] = value.getFloat();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Wrong argument for TupleColumnFloat");
        }
    }

    protected boolean hasStatistics() {
        return true;
    }

    public void defaultValue(Value value) {
        if (this.hasDefaultValue()) {
            value.set(this.getDefaultValue().getFloat());
        }
    }

    protected void currentArrayUpdated() {
        this.data = (float[])this.currentArray;
    }
}

