/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.util.UserProperties;

public class EMFExportFileType
extends AbstractExportFileType {
    private OptionCheckBox compress;

    public String getDescription() {
        return "Windows Enhanced Metafile";
    }

    public String[] getExtensions() {
        return new String[]{"emz", "EMZ", "emf", "EMF"};
    }

    public String[] getMIMETypes() {
        return new String[]{"image/x-emf"};
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, EMFGraphics2D.getDefaultProperties());
        String rootKey = EMFGraphics2D.class.getName();
        OptionPanel optionsPanel = new OptionPanel();
        optionsPanel.add("0 0 [5 5 5 5] wt", (Component)new BackgroundPanel((Properties)options, rootKey, true));
        optionsPanel.add("0 * wh", (Component)new JLabel());
        OptionPanel format = new OptionPanel("Format");
        this.compress = new OptionCheckBox((Properties)options, EMFGraphics2D.COMPRESS, "Compress");
        format.add("0 * * 1 [5 15 5 15] w", (Component)this.compress);
        optionsPanel.add("0 * wh", (Component)format);
        return optionsPanel;
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new EMFGraphics2D(os, target);
    }

    public File adjustFilename(File file, Properties user) {
        UserProperties options = new UserProperties(user, EMFGraphics2D.getDefaultProperties());
        if (options.isProperty(EMFGraphics2D.COMPRESS)) {
            return EMFExportFileType.adjustExtension((File)file, (String)"emz", null);
        }
        return EMFExportFileType.adjustExtension((File)file, (String)"emf", null);
    }
}

