/*
 * Decompiled with CFR 0.152.
 */
package sk.uniba.fmph.pocprak.ioutils;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import sk.uniba.fmph.pocprak.ioutils.OutTextFile;

public class InTextFile
extends LineNumberReader {
    private static InTextFile stdin = new InTextFile();
    private boolean isSTD = false;

    private InTextFile() {
        super(new InputStreamReader(System.in));
        this.isSTD = true;
    }

    private InTextFile(String fileName) throws FileNotFoundException {
        super(new FileReader(fileName));
    }

    public static InTextFile open() {
        return stdin;
    }

    public void close() throws IOException {
        if (this.isSTD) {
            return;
        }
        super.close();
    }

    public double[] readlnDoubles() throws IOException {
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(line, " ");
        int n = st.countTokens();
        double[] values = new double[n];
        for (int i = 0; i < n; ++i) {
            values[i] = Double.valueOf(st.nextToken());
        }
        return values;
    }

    public static InTextFile open(String fileName) throws FileNotFoundException {
        if (fileName.contentEquals(new StringBuffer(""))) {
            return InTextFile.open();
        }
        if (fileName.contentEquals(new StringBuffer("-"))) {
            return InTextFile.open();
        }
        return new InTextFile(fileName);
    }

    public static void main(String[] args) throws IOException {
        double[] input;
        InTextFile in = InTextFile.open();
        System.out.println(in.readLine());
        OutTextFile out = OutTextFile.open("doubles.txt");
        out.println("4.56 123.4");
        out.println();
        out.close();
        InTextFile ind = InTextFile.open("doubles.txt");
        while ((input = ind.readlnDoubles()) != null) {
            System.out.println("lineread");
            for (int i = 0; i < input.length; ++i) {
                System.out.println("double: " + input[i]);
            }
        }
    }
}

