/*
 * Decompiled with CFR 0.152.
 */
package sk.uniba.fmph.pocprak.simplegraphics;

import sk.uniba.fmph.pocprak.simplegraphics.GrAxisX;
import sk.uniba.fmph.pocprak.simplegraphics.GrAxisY;
import sk.uniba.fmph.pocprak.simplegraphics.GrFCN2;
import sk.uniba.fmph.pocprak.simplegraphics.GrGraphics;
import sk.uniba.fmph.pocprak.simplegraphics.SimpleGraphics;
import sk.uniba.fmph.pocprak.simplegraphics.testFCN2;

public class GrGraph2 {
    public static final int Gr_CONTOURS = 1;
    public GrFCN2 fcn;
    public double yMin = 0.0;
    public double yMax = 10.0;
    public double xMin = 0.0;
    public double xMax = 10.0;
    public double zMin = 0.0;
    public double zMax = 1.0;
    public int nBinsX = 500;
    public int nBinsY = 500;
    public int nBinsZ = 5;
    public double deltaX;
    public double deltaY;
    public double deltaZ;
    public double xPosition = 0.0;
    public double yPosition = 0.0;
    public GrAxisX aX;
    public GrAxisY aY;
    public double[] xvals;
    public double[] yvals;
    public double[] fcnvals;
    public double[] zvals;
    public double[] ervals;
    public int grType = 1;

    public GrGraph2(GrFCN2 FCN) {
        this.aX = new GrAxisX(this.xMin, this.xMax, this.yPosition);
        this.aY = new GrAxisY(this.yMin, this.yMax, this.xPosition);
        this.fcn = FCN;
        this.recalculate();
    }

    public GrGraph2(GrFCN2 FCN, double xmin, double x0, double xmax, double ymin, double y0, double ymax) {
        this.xMin = xmin;
        this.xMax = xmax;
        this.yPosition = x0;
        this.yMin = ymin;
        this.yMax = ymax;
        this.xPosition = y0;
        this.aX = new GrAxisX(this.xMin, this.xMax, this.yPosition);
        this.aY = new GrAxisY(this.yMin, this.yMax, this.xPosition);
        this.fcn = FCN;
        this.recalculate();
    }

    public GrGraph2(double xmin, double x0, double xmax, double ymin, double y0, double ymax) {
        this.xMin = xmin;
        this.xMax = xmax;
        this.yPosition = x0;
        this.yMin = ymin;
        this.yMax = ymax;
        this.xPosition = y0;
        this.aX = new GrAxisX(this.xMin, this.xMax, this.yPosition);
        this.aY = new GrAxisY(this.yMin, this.yMax, this.xPosition);
    }

    public void setFCN(GrFCN2 FCN) {
        this.fcn = FCN;
    }

    public void resetBins(int nbinsx, int nbinsy, int nbinsz) {
        this.nBinsX = nbinsx;
        this.nBinsY = nbinsy;
        this.nBinsZ = nbinsz;
        this.xvals = new double[this.nBinsX];
        this.yvals = new double[this.nBinsY];
        this.zvals = new double[this.nBinsZ];
        this.fcnvals = new double[this.nBinsX * this.nBinsY];
    }

    protected final int binn(int ix, int iy) {
        return ix * this.nBinsY + iy;
    }

    public void recalculate() {
        int iy;
        int ix;
        this.resetBins(this.nBinsX, this.nBinsY, this.nBinsZ);
        this.deltaX = (this.xMax - this.xMin) / (double)this.nBinsX;
        this.deltaY = (this.yMax - this.yMin) / (double)this.nBinsY;
        this.deltaZ = (this.zMax - this.zMin) / (double)this.nBinsZ;
        double x = this.xMin - 0.5 * this.deltaX;
        for (ix = 0; ix < this.nBinsX; ++ix) {
            this.xvals[ix] = x += this.deltaX;
        }
        double y = this.yMin - 0.5 * this.deltaY;
        for (iy = 0; iy < this.nBinsY; ++iy) {
            this.yvals[iy] = y += this.deltaY;
        }
        double z = this.zMin - 0.5 * this.deltaZ;
        for (int iz = 0; iz < this.nBinsZ; ++iz) {
            this.zvals[iz] = z += this.deltaZ;
        }
        for (ix = 0; ix < this.nBinsX; ++ix) {
            int iyoffset = ix * this.nBinsY;
            x = this.xvals[ix];
            for (iy = 0; iy < this.nBinsY; ++iy) {
                this.fcnvals[iy + iyoffset] = this.fcn.fcnvalue(x, this.yvals[iy]);
            }
        }
    }

    public void draw(GrGraphics gG) {
        this.aX.draw(gG);
        this.aY.draw(gG);
        switch (this.grType) {
            case 1: {
                for (int ix = 0; ix < this.nBinsX; ++ix) {
                    int iyoffset = ix * this.nBinsY;
                    for (int iy = 0; iy < this.nBinsY; ++iy) {
                        double z = this.fcnvals[iyoffset + iy];
                        for (int iz = 0; iz < this.nBinsZ; ++iz) {
                            if (!this.nearZ(z, this.zvals[iz])) continue;
                            gG.drawPoint(this.xvals[ix], this.yvals[iy]);
                        }
                    }
                }
                break;
            }
        }
    }

    protected boolean nearZ(double z, double zval) {
        return Math.abs(z - zval) < 0.02 * this.deltaZ;
    }

    public static void main(String[] args) {
        GrGraphics gr = SimpleGraphics.CreateGrEnvironment();
        gr.setBasePoint(GrGraphics.CENTER);
        gr.setUserFrameSize(0.0, 0.0, 5.0, 5.0);
        testFCN2 fcn2 = new testFCN2();
        GrGraph2 graph2 = new GrGraph2(fcn2, -4.0, 0.0, 4.0, -4.0, 0.0, 4.0);
        graph2.zMin = -1.0;
        graph2.recalculate();
        graph2.draw(gr);
        gr.repaint();
    }
}

