/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.ARGBColorChooserPanel;
import jas.util.Application;
import jas.util.ColorEvent;
import jas.util.ColorListener;
import jas.util.UserProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ColorChooser
extends JButton {
    private UserProperties m_prop;
    private String m_key;
    private Color m_color;
    private Vector m_listeners = new Vector();

    public ColorChooser() {
        this(Color.black);
    }

    public ColorChooser(Color color) {
        this.m_color = color;
        this.setIcon(new ColorChooserIcon());
    }

    public ColorChooser(String string) {
        this();
        this.m_prop = Application.getApplication().getUserProperties();
        this.m_key = string;
        this.setColor(this.m_prop.getColor(string, Color.black));
    }

    public void setColor(Color color) {
        this.m_color = color;
        this.repaint();
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ColorListener colorListener = (ColorListener)enumeration.nextElement();
            colorListener.colorChanged(new ColorEvent((Object)this, color));
        }
    }

    public Color getColor() {
        return this.m_color;
    }

    public void addColorListener(ColorListener colorListener) {
        this.m_listeners.addElement(colorListener);
    }

    public void removeColorListener(ColorListener colorListener) {
        this.m_listeners.removeElement(colorListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        int n;
        JColorChooser jColorChooser = new JColorChooser(this.m_color);
        jColorChooser.addChooserPanel(new ARGBColorChooserPanel());
        if (this.m_color.getAlpha() != 255) {
            AbstractColorChooserPanel[] abstractColorChooserPanelArray = jColorChooser.getChooserPanels();
            int n2 = abstractColorChooserPanelArray.length;
            AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = new AbstractColorChooserPanel[n2];
            for (int i = 1; i < n2; ++i) {
                abstractColorChooserPanelArray2[i] = abstractColorChooserPanelArray[i - 1];
            }
            abstractColorChooserPanelArray2[0] = abstractColorChooserPanelArray[n2 - 1];
            jColorChooser.setChooserPanels(abstractColorChooserPanelArray2);
        }
        if ((n = JOptionPane.showOptionDialog(this, jColorChooser, "Choose color...", 2, -1, null, null, null)) == 0) {
            Color color = jColorChooser.getColor();
            this.setColor(color);
            if (this.m_key != null) {
                this.m_prop.setColor(this.m_key, color);
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(20, 20);
    }

    private class ColorChooserIcon
    implements Icon {
        private ColorChooserIcon() {
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(ColorChooser.this.m_color);
            graphics.fillRect(n, n2, 16, 16);
        }
    }
}

