/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Application;
import jas.util.FieldBinding;
import jas.util.UnsupportedType;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.lang.reflect.Constructor;
import javax.swing.JOptionPane;

class TextFieldBinding
extends FieldBinding
implements TextListener {
    private String m_oldVal = "";
    private TextField m_field;
    private byte m_flags = 0;
    public static final byte MUST_BE_NUMBER = 1;
    public static final byte MUST_BE_INTEGER = 2;
    public static final byte MUST_BE_POSITIVE = 4;

    TextFieldBinding(TextField textField, byte by) {
        this(textField);
        this.m_flags = by;
    }

    TextFieldBinding(TextField textField) {
        this.m_field = textField;
        textField.addTextListener(this);
    }

    void set(Object object) {
        String string = object == null ? "" : (object instanceof String ? (String)object : object.toString());
        if (!this.m_oldVal.equals(string)) {
            this.m_field.setText(string);
            this.m_oldVal = string;
        }
    }

    Object get(Class clazz) throws UnsupportedType {
        Object var2_2 = null;
        String string = this.m_field.getText();
        if (clazz.isPrimitive()) {
            if (clazz == Double.TYPE) {
                return new Double(string);
            }
            if (clazz == Integer.TYPE) {
                return new Integer(string);
            }
            throw new UnsupportedType(this.m_field, clazz);
        }
        Class[] classArray = new Class[]{string.getClass()};
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{string};
            var2_2 = constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new UnsupportedType(this.m_field, clazz);
        }
        return var2_2;
    }

    public void textValueChanged(TextEvent textEvent) {
        String string = this.m_field.getText();
        if (!string.equals(this.m_oldVal)) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getText();
    }

    boolean hasValidInput() {
        String string = this.m_field.getText();
        if ((this.m_flags & 1) != 0) {
            try {
                double d;
                double d2 = d = (this.m_flags & 2) != 0 ? (double)Integer.parseInt(string) : Double.valueOf(string);
                if ((this.m_flags & 4) != 0 && d <= 0.0) {
                    JOptionPane.showMessageDialog(Application.getApplication().getFrame(), string.concat(" is invalid input; value must be positive."), "Error", 0);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(Application.getApplication().getFrame(), string + " is invalid input; value must be a" + ((this.m_flags & 2) != 0 ? "n integer." : " number."), "Error", 0);
                return false;
            }
        }
        return true;
    }
}

