/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.util.images.ImageHandler;

class CloseButtonTabbedPane
extends JTabbedPane {
    public static final boolean CLOSE_BUTTON_ENABLED = true;
    static final String TAB_NAME_TRAILING_SPACE = "   ";
    private static Image closeTabImage = ImageHandler.getImage("tabclose", CloseButtonTabbedPane.class);
    private static Image closeTabInactiveImage = ImageHandler.getImage("tabcloseinactive", CloseButtonTabbedPane.class);
    private boolean draggedOut = false;
    private int mouseOverCloseButtonIndex = -1;
    private int pressedCloseButtonIndex = -1;

    CloseButtonTabbedPane() {
        CloseButtonListener cl = new CloseButtonListener();
        this.addMouseListener(cl);
        this.addMouseMotionListener(cl);
        this.addChangeListener(cl);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paint(Graphics g) {
        super.paint(g);
        int selectedIndex = this.getSelectedIndex();
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Rectangle r = this.getCloseButtonBoundsAt(i);
            if (r == null) continue;
            if (i == this.pressedCloseButtonIndex && !this.draggedOut) {
                g.setColor(new Color(153, 153, 153));
                g.fillRect(r.x, r.y, r.width, r.height);
            }
            if (i != selectedIndex) {
                g.drawImage(closeTabInactiveImage, r.x + 2, r.y + 2, this);
            } else {
                g.drawImage(closeTabImage, r.x + 2, r.y + 2, this);
            }
            if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                g.setColor(new Color(102, 102, 102));
                g.drawRect(r.x, r.y, r.width, r.height);
                g.setColor(i == selectedIndex ? new Color(255, 255, 255) : new Color(204, 204, 204));
                g.drawRect(r.x + 1, r.y + 1, r.width, r.height);
                g.setColor(new Color(162, 162, 162));
                g.drawLine(r.x + r.width, r.y + 1, r.x + r.width, r.y + 1);
                g.drawLine(r.x + 1, r.y + r.height, r.x + 1, r.y + r.height);
                continue;
            }
            if (i != this.pressedCloseButtonIndex) continue;
            g.setColor(new Color(102, 102, 102));
            g.drawRect(r.x, r.y, r.width, r.height);
            g.setColor(i == selectedIndex ? new Color(255, 255, 255) : new Color(204, 204, 204));
            g.drawLine(r.x + 1, r.y + r.height + 1, r.x + r.width + 1, r.y + r.height + 1);
            g.drawLine(r.x + r.width + 1, r.y + 1, r.x + r.width + 1, r.y + r.height + 1);
            g.setColor(new Color(153, 153, 153));
            g.drawLine(r.x + 1, r.y + 1, r.x + r.width, r.y + 1);
            g.drawLine(r.x + 1, r.y + 1, r.x + 1, r.y + r.height);
        }
    }

    protected void fireCloseTabAt(int index) {
        this.removeTabAt(index);
    }

    private Rectangle getCloseButtonBoundsAt(int i) {
        Rectangle b = this.getBoundsAt(i);
        if (b == null) {
            return null;
        }
        b = new Rectangle(b);
        Dimension tabsz = this.getSize();
        if (b.x + b.width >= tabsz.width || b.y + b.height >= tabsz.height) {
            return null;
        }
        return new Rectangle(b.x + b.width - 13, b.y + b.height / 2 - 5, 8, 8);
    }

    private void setMouseOverCloseButtonIndex(int index) {
        Rectangle r;
        if (this.mouseOverCloseButtonIndex == index) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
        }
        this.mouseOverCloseButtonIndex = index;
        if (this.mouseOverCloseButtonIndex >= 0) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private void setPressedCloseButtonIndex(int index) {
        Rectangle r;
        if (this.pressedCloseButtonIndex == index) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
        }
        this.pressedCloseButtonIndex = index;
        if (this.pressedCloseButtonIndex >= 0) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private class CloseButtonListener
    extends MouseAdapter
    implements MouseMotionListener,
    ChangeListener {
        private CloseButtonListener() {
        }

        public void mouseDragged(MouseEvent e) {
            if (CloseButtonTabbedPane.this.pressedCloseButtonIndex >= 0) {
                Rectangle r = CloseButtonTabbedPane.this.getCloseButtonBoundsAt(CloseButtonTabbedPane.this.pressedCloseButtonIndex);
                if (r != null && CloseButtonTabbedPane.this.draggedOut != !r.contains(e.getPoint())) {
                    CloseButtonTabbedPane.this.draggedOut = !r.contains(e.getPoint());
                    CloseButtonTabbedPane.this.repaint(r.x, r.y, r.width + 2, r.height + 2);
                }
                e.consume();
            }
        }

        public void mouseMoved(MouseEvent e) {
            int index = CloseButtonTabbedPane.this.indexAtLocation(e.getX(), e.getY());
            if (index >= 0) {
                Rectangle r = CloseButtonTabbedPane.this.getCloseButtonBoundsAt(index);
                if (r != null && r.contains(e.getPoint())) {
                    CloseButtonTabbedPane.this.setMouseOverCloseButtonIndex(index);
                    CloseButtonTabbedPane.this.draggedOut = false;
                    e.consume();
                } else if (CloseButtonTabbedPane.this.mouseOverCloseButtonIndex >= 0) {
                    CloseButtonTabbedPane.this.setMouseOverCloseButtonIndex(-1);
                    CloseButtonTabbedPane.this.draggedOut = false;
                    e.consume();
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            Rectangle r;
            int index = CloseButtonTabbedPane.this.indexAtLocation(e.getX(), e.getY());
            if (index >= 0 && (r = CloseButtonTabbedPane.this.getCloseButtonBoundsAt(index)) != null && r.contains(e.getPoint())) {
                CloseButtonTabbedPane.this.setPressedCloseButtonIndex(index);
                CloseButtonTabbedPane.this.draggedOut = false;
                e.consume();
            }
        }

        public void mouseReleased(MouseEvent e) {
            Rectangle r;
            int tabIndex = CloseButtonTabbedPane.this.pressedCloseButtonIndex;
            if (tabIndex >= 0 && (r = CloseButtonTabbedPane.this.getCloseButtonBoundsAt(tabIndex)) != null && r.contains(e.getPoint()) && tabIndex >= 0) {
                CloseButtonTabbedPane.this.reset();
                CloseButtonTabbedPane.this.fireCloseTabAt(tabIndex);
                e.consume();
                return;
            }
            CloseButtonTabbedPane.this.reset();
        }

        public void stateChanged(ChangeEvent e) {
            CloseButtonTabbedPane.this.reset();
        }
    }
}

