/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.freehep.application.Application;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.mdi.InternalFramePageManager;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.mdi.TabbedPageManager;
import org.freehep.application.mdi.ToolBarHolder;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandProcessor;

public class MDIApplication
extends Application {
    public static final int TOOLBAR_DEFAULT = 0;
    public static final int TOOLBAR_INVISIBLE = 1;
    public static final int TOOLBAR_VISIBLE = 2;
    public static final int TOOLBAR_AUTO = 3;
    public static final int TOOLBAR_PROGRAM = 4;
    private PageListener pageListener = new MDIPageListener();
    private PageManager pageManager;
    private PageManager controlManager;
    private PageManager consoleManager;
    private JSplitPane consoleSplit;
    private JSplitPane controlSplit;
    private ToolBarHolder mdiToolBarHolder;

    public MDIApplication(String appName) {
        super(appName);
        this.add(this.getPageManager().getEmbodiment());
    }

    protected void loadDefaultProperties(Properties app) throws IOException {
        super.loadDefaultProperties(app);
        InputStream in = MDIApplication.class.getResourceAsStream("MDIDefault.properties");
        app.load(in);
        in.close();
    }

    protected void saveUserProperties() {
        Properties user = this.getUserProperties();
        if (this.consoleSplit != null) {
            PropertyUtilities.setInteger(user, "consoleSize", this.consoleSplit.getHeight() - this.consoleSplit.getDividerLocation());
        }
        if (this.controlSplit != null) {
            PropertyUtilities.setInteger(user, "controlSize", this.controlSplit.getDividerLocation());
        }
        if (this.mdiToolBarHolder != null) {
            this.mdiToolBarHolder.save(user);
        }
        super.saveUserProperties();
    }

    public void addToolBar(JToolBar toolBar, String name, int mode) {
        if (this.mdiToolBarHolder == null) {
            this.mdiToolBarHolder = new ToolBarHolder();
            this.getToolBarHolder().add((Component)this.mdiToolBarHolder, "North");
        }
        if (mode == 0) {
            mode = PropertyUtilities.getInteger(this.getUserProperties(), "ToolBar." + name, mode);
        }
        this.mdiToolBarHolder.add(toolBar, name, mode);
    }

    public void addToolBar(JToolBar toolBar, String name) {
        this.addToolBar(toolBar, name, 0);
    }

    public void removeToolBar(JToolBar toolBar) {
        this.mdiToolBarHolder.remove(toolBar);
    }

    public PageManager getPageManager() {
        if (this.pageManager == null) {
            this.setPageManager(this.createPageManager());
        }
        return this.pageManager;
    }

    public void setPageManager(PageManager manager) {
        if (manager == this.pageManager) {
            return;
        }
        Component oldEmbodiment = null;
        if (this.pageManager != null) {
            this.getCommandTargetManager().remove(this.pageManager.getCommandProcessor());
            oldEmbodiment = this.pageManager.getEmbodiment();
        }
        this.switchPageManager(this.pageManager, manager);
        this.getCommandTargetManager().add(manager.getCommandProcessor());
        if (this.pageManager != null) {
            Container parent = oldEmbodiment.getParent();
            int index = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                if (parent.getComponent(i) != oldEmbodiment) continue;
                index = i;
                break;
            }
            parent.remove(index);
            Component page = manager.getEmbodiment();
            MDIApplication.updateComponentTreeUI(page);
            parent.add(page, index);
            parent.validate();
            this.getCommandProcessor().setChanged();
        }
        this.pageManager = manager;
    }

    public PageManager getControlManager() {
        if (this.controlManager == null) {
            this.setControlManager(this.createControlManager());
        }
        return this.controlManager;
    }

    public void setControlManager(PageManager manager) {
        if (manager == this.controlManager) {
            return;
        }
        this.switchPageManager(this.controlManager, manager);
        this.controlManager = manager;
    }

    public PageManager getConsoleManager() {
        if (this.consoleManager == null) {
            this.setConsoleManager(this.createConsoleManager());
        }
        return this.consoleManager;
    }

    public void setConsoleManager(PageManager manager) {
        if (manager == this.consoleManager) {
            return;
        }
        this.switchPageManager(this.consoleManager, manager);
        this.consoleManager = manager;
    }

    protected PageManager createPageManager() {
        return this.createManager("pageManager");
    }

    protected PageManager createControlManager() {
        return this.createManager("controlManager");
    }

    protected PageManager createConsoleManager() {
        return this.createManager("consoleManager");
    }

    protected PageManager createManager(String type) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            Class<?> k = loader.loadClass(this.getUserProperties().getProperty(type));
            return (PageManager)k.newInstance();
        }
        catch (Exception x) {
            throw new Application.InitializationException("Could not create PageManager: " + type, x);
        }
    }

    private void switchPageManager(PageManager oldManager, PageManager newManager) {
        newManager.setActive(true);
        if (oldManager != null) {
            List listeners = oldManager.getPageListenerList();
            oldManager.removeAllPageListeners();
            List l = oldManager.pages();
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                newManager.addPageListener((PageListener)i.next());
            }
            newManager.init(l, oldManager.getSelectedPage());
            oldManager.setActive(false);
        } else {
            newManager.addPageListener(this.pageListener);
        }
    }

    private void showControl(boolean show) {
        if (show && this.controlSplit == null) {
            Component pages = this.pageManager.getEmbodiment();
            Container parent = pages.getParent();
            parent.remove(pages);
            Component control = this.controlManager.getEmbodiment();
            MDIApplication.updateComponentTreeUI(control);
            this.controlSplit = new JSplitPane(1, control, pages);
            int pixels = PropertyUtilities.getInteger(this.getUserProperties(), "controlSize", -1);
            if (pixels > 0) {
                this.controlSplit.setDividerLocation(pixels);
            }
            parent.add(this.controlSplit);
            this.revalidate();
        } else if (!show && this.controlSplit != null) {
            PropertyUtilities.setInteger(this.getUserProperties(), "controlSize", this.controlSplit.getDividerLocation());
            Component pages = this.pageManager.getEmbodiment();
            Container parent = this.controlSplit.getParent();
            parent.remove(this.controlSplit);
            this.controlSplit.removeAll();
            this.controlSplit = null;
            parent.add(pages);
            this.revalidate();
        }
    }

    private void showConsole(boolean show) {
        if (show && this.consoleSplit == null) {
            Component old = this.getComponent(0);
            final int height = old.getHeight();
            this.remove(old);
            final int pixels = PropertyUtilities.getInteger(this.getUserProperties(), "consoleSize", -1);
            Component console = this.consoleManager.getEmbodiment();
            MDIApplication.updateComponentTreeUI(console);
            this.consoleSplit = new JSplitPane(0, old, console){
                int consoleSize;
                {
                    super(x0, x1, x2);
                    this.consoleSize = height > 0 ? -1 : pixels;
                }

                public void doLayout() {
                    if (this.consoleSize > 0) {
                        int height2 = this.getHeight();
                        this.setDividerLocation(height2 - this.consoleSize);
                        this.consoleSize = -1;
                    }
                    super.doLayout();
                }
            };
            this.consoleSplit.setResizeWeight(1.0);
            if (pixels > 0 && height > 0) {
                this.consoleSplit.setDividerLocation(height - pixels);
            }
            this.add(this.consoleSplit);
            this.revalidate();
        } else if (!show && this.consoleSplit != null) {
            int consoleSize = this.consoleSplit.getHeight() - this.consoleSplit.getDividerLocation();
            PropertyUtilities.setInteger(this.getUserProperties(), "consoleSize", consoleSize);
            Component old = this.consoleSplit.getTopComponent();
            this.remove(this.consoleSplit);
            this.consoleSplit.removeAll();
            this.consoleSplit = null;
            this.add(old);
            this.revalidate();
        }
    }

    protected CommandProcessor createCommandProcessor() {
        return new MDICommandProcessor();
    }

    protected class MDICommandProcessor
    extends Application.ApplicationCommandProcessor {
        protected MDICommandProcessor() {
        }

        public void onTabbedPanes(boolean state) {
            if (state) {
                MDIApplication.this.setPageManager(new TabbedPageManager());
                MDIApplication.this.getUserProperties().setProperty("pageManager", MDIApplication.this.getPageManager().getClass().getName());
            }
        }

        public void enableTabbedPanes(BooleanCommandState state) {
            state.setEnabled(true);
            state.setSelected(MDIApplication.this.getPageManager() instanceof TabbedPageManager);
        }

        public void onInternalFrames(boolean state) {
            if (state) {
                MDIApplication.this.setPageManager(new InternalFramePageManager());
                MDIApplication.this.getUserProperties().setProperty("pageManager", MDIApplication.this.getPageManager().getClass().getName());
            }
        }

        public void enableInternalFrames(BooleanCommandState state) {
            state.setEnabled(true);
            state.setSelected(MDIApplication.this.getPageManager() instanceof InternalFramePageManager);
        }
    }

    private class MDIPageListener
    implements PageListener {
        private MDIPageListener() {
        }

        public void pageChanged(PageEvent event) {
            PageManager manager;
            int id = event.getID();
            if (id == 4004) {
                PageManager manager2 = event.getPageContext().getPageManager();
                if (manager2.getPageCount() == 1) {
                    if (manager2 == MDIApplication.this.controlManager) {
                        MDIApplication.this.showControl(true);
                    }
                    if (manager2 == MDIApplication.this.consoleManager) {
                        MDIApplication.this.showConsole(true);
                    }
                }
            } else if (id == 4001 && (manager = event.getPageContext().getPageManager()).getPageCount() == 0) {
                if (manager == MDIApplication.this.controlManager) {
                    MDIApplication.this.showControl(false);
                }
                if (manager == MDIApplication.this.consoleManager) {
                    MDIApplication.this.showConsole(false);
                }
            }
        }
    }
}

