/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freehep.application.ApplicationEvent;
import org.freehep.application.mdi.InternalFramePageManager;
import org.freehep.application.mdi.MDIApplication;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.mdi.TabbedPageManager;
import org.freehep.application.studio.EventSender;
import org.freehep.application.studio.ExtensionClassLoader;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginInfo;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commandline.CommandLine;
import org.freehep.xml.util.ClassPathEntityResolver;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.util.Lookup;
import org.xml.sax.EntityResolver;

public class Studio
extends MDIApplication {
    private FreeHEPLookup lookup;
    private List loadedPlugins = new ArrayList();
    private EventSender sender = new EventSender();
    private boolean debugExtensions = System.getProperty("debugExtensions") != null;
    private SAXBuilder builder = new SAXBuilder(true);
    private ExtensionClassLoader extensionLoader;
    public static final String LOADDIR = "loaddir";
    private boolean isApplicationVisible = false;
    private boolean isApplicationInitialized = false;
    private boolean atLeastOnePluginFailedToLoad = false;

    protected Studio(String name) {
        super(name);
        this.builder.setEntityResolver((EntityResolver)new ClassPathEntityResolver("plugin.dtd", Studio.class));
        this.getLookup().add((Object)new TabbedPageManager(), "Tabbed Panes");
        this.getLookup().add((Object)new InternalFramePageManager(), "Internal Frames");
    }

    private Studio() {
        this("Studio");
    }

    protected FreeHEPLookup createLookup() {
        return FreeHEPLookup.instance();
    }

    public EventSender getEventSender() {
        return this.sender;
    }

    public FreeHEPLookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    public void stopPlugin(PluginInfo plugin) {
        Plugin plug = plugin.getPlugin();
        if (plug == null || !plug.canBeShutDown()) {
            throw new IllegalArgumentException("Plugin can not be shutdown");
        }
        plug.stop();
        plugin.setPlugin(null);
    }

    public void startPlugin(PluginInfo plugin) throws Throwable {
        Plugin plug = this.initializePlugin(plugin, this.extensionLoader);
        this.revalidate();
    }

    private Plugin initializePlugin(PluginInfo plugin, ClassLoader loader) throws Throwable {
        try {
            this.getAppProperties().putAll((Map<?, ?>)plugin.getProperties());
            Class<?> c = loader.loadClass(plugin.getMainClass());
            Plugin plug = (Plugin)c.newInstance();
            plug.setContext(this);
            plugin.setPlugin(plug);
            if (this.isApplicationInitialized) {
                plug.postInit();
            }
            if (this.isApplicationVisible) {
                plug.applicationVisible();
            }
            plugin.setErrorStatus(null);
            return plug;
        }
        catch (Throwable t) {
            plugin.setErrorStatus(t);
            throw t;
        }
    }

    public List getPlugins() {
        return this.loadedPlugins;
    }

    public static void main(String[] args) {
        new Studio().createFrame(args).setVisible(true);
    }

    protected CommandLine createCommandLine() {
        CommandLine cl = super.createCommandLine();
        cl.addOption("extdir", null, "directory", "Sets the directory to scan for plugins");
        return cl;
    }

    protected void init() {
        super.init();
        this.setStatusMessage("Loading extensions...");
        this.loadExtensions();
        this.setStatusMessage("Setting page manager...");
        this.setPageManager(this.createRealPageManager());
        if (this.atLeastOnePluginFailedToLoad) {
            this.error("At least one plugin failed to load, see Plugin Manager for details");
        }
    }

    protected PageManager createRealPageManager() {
        String name = this.getUserProperties().getProperty("pageManagerName", "Tabbed Panes");
        Lookup.Template template = new Lookup.Template(PageManager.class, name, null);
        Lookup.Result result = this.getLookup().lookup(template);
        if (!result.allInstances().isEmpty()) {
            return (PageManager)result.allInstances().iterator().next();
        }
        try {
            return super.createPageManager();
        }
        catch (Throwable t) {
            PageManager pm = (PageManager)this.getLookup().lookup(PageManager.class);
            if (pm != null) {
                return pm;
            }
            return new TabbedPageManager();
        }
    }

    private void loadExtensions() {
        TreeMap extensionClasspath = new TreeMap();
        LinkedHashSet plugins = new LinkedHashSet();
        String[] extDirs = new String[]{this.getSystemExtensionsDir(), this.getGroupExtensionsDir(), this.getUserExtensionsDir()};
        this.scanExtensionDirectories(extDirs, extensionClasspath, plugins);
        URL[] urls = new URL[extensionClasspath.size()];
        extensionClasspath.values().toArray(urls);
        this.extensionLoader = new ExtensionClassLoader(urls);
        this.createLookup().setClassLoader(this.extensionLoader);
        Runnable lola = new Runnable(){

            public void run() {
                Thread.currentThread().setContextClassLoader(Studio.this.extensionLoader);
            }
        };
        lola.run();
        SwingUtilities.invokeLater(lola);
        this.loadPlugins(new ArrayList(plugins), this.extensionLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List buildPluginList(InputStream in, File loadDir) throws IOException {
        Properties user = this.getUserProperties();
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        try {
            Document doc = this.builder.build(in);
            Element root = doc.getRootElement();
            Iterator iter = root.getChildren().iterator();
            while (iter.hasNext()) {
                Element node = (Element)iter.next();
                PluginInfo plugin = new PluginInfo(node);
                plugin.setLoadDirectory(loadDir);
                plugin.loadUserProperties(user);
                result.add(plugin);
                if (!this.debugExtensions) continue;
                System.out.println("\t\tPlugin: " + plugin.getName());
            }
        }
        catch (JDOMException x) {
            if (this.debugExtensions) {
                x.printStackTrace();
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    public void loadPlugins(List plugins, ClassLoader loader) {
        Iterator iter = plugins.iterator();
        while (iter.hasNext()) {
            PluginInfo plugin = (PluginInfo)iter.next();
            this.loadedPlugins.add(plugin);
            if (!plugin.isLoadAtStart()) continue;
            try {
                this.setStatusMessage("Loading " + plugin.getName() + "...");
                if (this.debugExtensions) {
                    System.out.println("Loading plugin: " + plugin.getName());
                }
                long start = System.currentTimeMillis();
                this.initializePlugin(plugin, loader);
                plugin.setErrorStatus(null);
                long stop = System.currentTimeMillis();
                if (!this.debugExtensions) continue;
                System.out.println("Done loading in : " + (stop - start) + "ms");
            }
            catch (Throwable t) {
                if (this.debugExtensions) {
                    System.err.println("Unable to load plugin " + plugin.getName());
                }
                plugin.setErrorStatus(t);
                this.atLeastOnePluginFailedToLoad = true;
            }
        }
        this.revalidate();
    }

    private void scanExtensionDirectories(String[] dirs, Map extensionClasspath, Set plugins) {
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i] == null) continue;
            File extdir = new File(dirs[i]);
            if (this.debugExtensions) {
                System.out.println("Seaching for extensions in: " + extdir);
            }
            if (!extdir.isDirectory()) continue;
            this.scanExtensionDirectory(extdir, extensionClasspath, plugins);
        }
    }

    private void scanExtensionDirectory(File extdir, Map extensionClasspath, Set plugins) {
        String[] files = extdir.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(".jar")) continue;
            File f = new File(extdir, files[i]);
            if (f.length() > 0L) {
                try {
                    JarFile jarFile;
                    JarEntry manifest;
                    if (this.debugExtensions) {
                        System.out.println("\tFound: " + files[i]);
                    }
                    if ((manifest = (jarFile = new JarFile(f)).getJarEntry("PLUGIN-inf/plugins.xml")) != null) {
                        InputStream in = jarFile.getInputStream(manifest);
                        List newPlugins = this.buildPluginList(in, extdir);
                        boolean rc = plugins.removeAll(newPlugins);
                        plugins.addAll(newPlugins);
                    }
                    jarFile.close();
                    extensionClasspath.put(f.getName(), f.toURI().toURL());
                }
                catch (IOException x) {
                    System.err.println("Extension jar file " + files[i] + " could not be loaded" + x);
                }
                continue;
            }
            f.delete();
        }
    }

    public String getUserExtensionsDir() {
        String extdir = this.getCommandLine().getOption("extdir");
        if (extdir != null) {
            return extdir;
        }
        return this.getAppProperties().getProperty("org.freehep.application.studio.user.extensions", "{user.home}/.FreeHEPPlugins");
    }

    public String getGroupExtensionsDir() {
        return this.getAppProperties().getProperty("org.freehep.application.studio.group.extensions");
    }

    public String getSystemExtensionsDir() {
        return this.getAppProperties().getProperty("org.freehep.application.studio.system.extensions", "{java.home}/FreeHEPPlugins");
    }

    public ExtensionClassLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    protected void fireInitializationComplete(ApplicationEvent event) {
        super.fireInitializationComplete(event);
        this.getEventSender().broadcast(event);
        Iterator i = this.loadedPlugins.iterator();
        while (i.hasNext()) {
            PluginInfo info = (PluginInfo)i.next();
            Plugin plugin = info.getPlugin();
            if (plugin == null) continue;
            plugin.postInit();
        }
        this.isApplicationInitialized = true;
    }

    protected void fireApplicationVisible(ApplicationEvent event) {
        super.fireApplicationVisible(event);
        this.getEventSender().broadcast(event);
        Iterator i = this.loadedPlugins.iterator();
        while (i.hasNext()) {
            PluginInfo info = (PluginInfo)i.next();
            Plugin plugin = info.getPlugin();
            if (plugin == null) continue;
            plugin.applicationVisible();
        }
        this.isApplicationVisible = true;
    }

    protected void fireAboutToExit(ApplicationEvent event) {
        Iterator i = this.loadedPlugins.iterator();
        while (i.hasNext()) {
            PluginInfo info = (PluginInfo)i.next();
            Properties user = this.getUserProperties();
            info.saveUserProperties(user);
        }
        super.fireAboutToExit(event);
        this.getEventSender().broadcast(event);
    }

    protected PageManager createPageManager() {
        return new DummyPageManager();
    }

    private static class DummyPageManager
    extends PageManager {
        private JPanel panel = new JPanel();

        private DummyPageManager() {
        }

        protected Component getEmbodiment() {
            return this.panel;
        }

        protected void iconChanged(PageContext page) {
        }

        protected void show(PageContext page) {
        }

        protected void titleChanged(PageContext page) {
        }
    }
}

