/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.IPlotter;
import hep.aida.IPlotterFactory;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.ref.fitter.Fitter;
import hep.aida.ref.fitter.fitData.FitData;
import hep.aida.ref.function.FunctionCore;
import java.io.IOException;
import java.util.Random;

public class ExponentialCoreNorm
extends FunctionCore {
    protected boolean providesNormalization;

    public ExponentialCoreNorm(String str) {
        super(1, 1, new double[]{1.0});
        this.setTitle("ExponentialCoreNorm::" + str);
        this.providesNormalization = true;
        String[] names = new String[]{"exponent"};
        this.setParameterNames(names);
    }

    public ExponentialCoreNorm(String str, double[] pVal) {
        super(1, 1, pVal);
        this.setTitle("ExponentialCoreNorm::" + str);
        this.providesNormalization = true;
        String[] names = new String[]{"exponent"};
        this.setParameterNames(names);
    }

    public double functionValue(double[] var) {
        double val = Math.exp(var[0] * this.p[0]);
        return val;
    }

    public boolean providesGradient() {
        return true;
    }

    public double[] gradient(double[] var) {
        return new double[]{this.functionValue(var) * this.p[0]};
    }

    public boolean providesParameterGradient() {
        return true;
    }

    public double[] parameterGradient(double[] var) {
        return new double[]{this.functionValue(var) * var[0]};
    }

    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        double val = 0.0;
        val = (this.functionValue(new double[]{xMax[0]}) - this.functionValue(new double[]{xMin[0]})) / this.p[0];
        return val;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Start ExponentialCoreNorm");
        IAnalysisFactory af = IAnalysisFactory.create();
        System.out.println("af=" + af);
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ITupleFactory tf = af.createTupleFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IPlotterFactory pf = af.createPlotterFactory();
        IPlotter plotter = pf.create("JAS Plotter");
        plotter.createRegions(2, 2);
        IModelFunction f1 = (IModelFunction)ff.createFunctionByName("f1", "e");
        IModelFunction f2 = (IModelFunction)ff.createFunctionByName("f2", "e");
        IModelFunction f3 = (IModelFunction)ff.createFunctionByName("f3", "e");
        IModelFunction f4 = (IModelFunction)ff.createFunctionByName("f4", "e");
        IHistogram1D hist1 = hf.createHistogram1D("hist1", "hist1", 100, -5.0, 5.0);
        IHistogram1D hist2 = hf.createHistogram1D("hist2", "hist2", 100, -5.0, 5.0);
        IHistogram2D hist2d = hf.createHistogram2D("hist2d", "hist2d", 100, -5.0, 5.0, 10, -10.0, 0.0);
        Random r = new Random();
        ITuple tup = tf.create("tup", "tup", "double x0, double y");
        System.out.println("Filling tuple");
        for (int i = 0; i < 50000; ++i) {
            double d;
            double x = 10.0 * (r.nextDouble() - 0.5);
            double y = r.nextDouble() * 2.0;
            if (!(y < (d = Math.exp((x - 2.0) / 5.0)))) continue;
            hist1.fill(x);
            hist2d.fill(x, y);
            tup.fill(0, x);
            tup.fill(1, y);
            tup.addRow();
        }
        System.out.println("Filled Histograms and Tuple");
        System.out.println("Filling tuple done");
        double[] chi2 = new double[]{10.0, 1.5};
        f1.setParameters(chi2);
        f2.setParameters(chi2);
        f2.normalize(false);
        Fitter fitter = new Fitter("Chi2", "uncmin", null);
        System.out.println("about to fit");
        fitter.fit((IBaseHistogram)hist1, "e");
        System.out.println("Fit done!");
        plotter.currentRegion().plot((IBaseHistogram)hist1);
        plotter.currentRegion().plot((IFunction)f1);
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist1);
        plotter.currentRegion().plot((IFunction)f1);
        plotter.currentRegion().plot((IFunction)f2);
        System.out.println("show");
        plotter.show();
        for (int i = 0; i < 1; ++i) {
            hist2.fill(0.1);
        }
        f3.normalize(true);
        f4.normalize(true);
        System.out.println("Set Normalization for f3 and f4");
        f3.excludeNormalizationAll();
        f3.normalizationRange(0).include(-5.0, 5.0);
        f4.excludeNormalizationAll();
        f4.normalizationRange(0).include(-5.0, 5.0);
        System.out.println("Set Normalization range for f3 and f4");
        double[] ml = new double[]{-0.5};
        f3.setParameters(ml);
        f4.setParameters(ml);
        System.out.println("Variable names: " + f4.variableName(0));
        Object ev = null;
        FitData fd = new FitData();
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist2);
        plotter.currentRegion().plot((IFunction)f3);
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist2);
        plotter.currentRegion().plot((IFunction)f4);
        plotter.show();
        System.out.println("Done");
    }
}

