/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IModelFunction;
import hep.aida.IRangeSet;
import hep.aida.ref.function.FunctionFactory;
import java.util.Random;

public class Grid {
    private final int maxBins = 50;
    private int gridDim;
    private double[][] lowerEdges;
    private double[][] upperEdges;
    private double[][] widths;
    private double[][][] values;
    private double[][][] binEdges;
    private int[] dimBlocks;
    private double[] xin;
    private double[][] weights;
    private boolean isValid;
    private double gridVol;
    private int gridBins;
    private int gridBoxes;
    Random rnd = new Random();

    public Grid(IModelFunction func) {
        this.gridDim = func.dimension();
        this.lowerEdges = new double[this.gridDim][];
        this.upperEdges = new double[this.gridDim][];
        this.widths = new double[this.gridDim][];
        this.dimBlocks = new int[this.gridDim];
        this.values = new double[this.gridDim][50][];
        this.binEdges = new double[this.gridDim][51][];
        this.xin = new double[51];
        this.weights = new double[50][];
        this.initialize(func);
    }

    protected void initialize(IModelFunction func) {
        this.gridVol = 1.0;
        this.gridBins = 1;
        for (int i = 0; i < this.gridDim; ++i) {
            IRangeSet rangeSet = func.normalizationRange(i);
            int size = rangeSet.size();
            this.lowerEdges[i] = rangeSet.lowerBounds();
            this.upperEdges[i] = rangeSet.upperBounds();
            this.widths[i] = new double[size];
            this.dimBlocks[i] = size;
            for (int m = 0; m < 50; ++m) {
                this.binEdges[i][m] = new double[size];
                this.values[i][m] = new double[size];
                if (i != 0) continue;
                this.weights[m] = new double[size];
            }
            this.binEdges[i][50] = new double[size];
            double rangeWidth = 0.0;
            for (int j = 0; j < size; ++j) {
                if (Double.isInfinite(this.lowerEdges[i][j]) || Double.isInfinite(this.upperEdges[i][j])) {
                    throw new IllegalArgumentException("Cannot have infinite ranges");
                }
                double width = this.upperEdges[i][j] - this.lowerEdges[i][j];
                if (width <= 0.0) {
                    throw new IllegalArgumentException("Invalid range of width " + width);
                }
                rangeWidth += width;
                this.widths[i][j] = width;
                this.binEdges[i][0][j] = 0.0;
                this.binEdges[i][1][j] = 1.0;
            }
            this.gridVol *= rangeWidth;
        }
        this.isValid = true;
    }

    protected void resize(int bins) {
        if (bins == this.gridBins) {
            return;
        }
        double grane = (double)this.gridBins / (double)bins;
        for (int i = 0; i < this.gridDim; ++i) {
            for (int k = 0; k < this.dimBlocks[i]; ++k) {
                double xNew = 0.0;
                double delta = 0.0;
                int count = 1;
                for (int j = 1; j <= this.gridBins; ++j) {
                    delta += 1.0;
                    double xOld = xNew;
                    xNew = this.binEdges[i][j][k];
                    while (delta > grane) {
                        this.xin[count++] = xNew - (xNew - xOld) * (delta -= grane);
                    }
                }
                for (int n = 1; n < bins; ++n) {
                    this.binEdges[i][n][k] = this.xin[n];
                }
                this.binEdges[i][bins][k] = 1.0;
            }
        }
        this.gridBins = bins;
    }

    protected void resetValues() {
        for (int i = 0; i < this.gridDim; ++i) {
            for (int j = 0; j < this.gridBins; ++j) {
                for (int k = 0; k < this.dimBlocks[i]; ++k) {
                    this.values[i][j][k] = 0.0;
                }
            }
        }
    }

    protected void generatePoint(int[][] box, double[] x, int[][] bin, double[] vol) {
        vol[0] = 1.0;
        for (int i = 0; i < this.gridDim; ++i) {
            int block;
            int binIndex;
            x[i] = this.rnd.nextDouble();
            double point = ((double)box[i][0] + x[i]) / (double)this.gridBoxes * (double)this.gridBins;
            bin[i][0] = binIndex = (int)point;
            bin[i][1] = block = box[i][1];
            double binWidth = this.binEdges[i][binIndex + 1][block] - this.binEdges[i][binIndex][block];
            double length = this.binEdges[i][binIndex][block] + (point - (double)binIndex) * binWidth;
            x[i] = this.lowerEdges[i][block] + length * this.widths[i][block];
            vol[0] = vol[0] * binWidth;
        }
    }

    protected int[][] firstBox() {
        int[][] box = new int[this.gridDim][2];
        for (int i = 0; i < this.gridDim; ++i) {
            for (int j = 0; j < 2; ++j) {
                box[i][j] = 0;
            }
        }
        return box;
    }

    protected boolean nextBox(int[][] box) {
        for (int j = this.gridDim - 1; j >= 0; --j) {
            box[j][0] = (box[j][0] + 1) % this.gridBoxes;
            if (0 != box[j][0]) {
                return true;
            }
            box[j][1] = (box[j][1] + 1) % this.dimBlocks[j];
            if (0 == box[j][1]) continue;
            return true;
        }
        return false;
    }

    protected int maxBins() {
        return 50;
    }

    protected void refine(double alpha) {
        for (int i = 0; i < this.gridDim; ++i) {
            for (int k = 0; k < this.dimBlocks[i]; ++k) {
                int j;
                double oldVal = this.values[i][0][k];
                double newVal = this.values[i][1][k];
                this.values[i][0][k] = (oldVal + newVal) / 2.0;
                double content = this.values[i][0][k];
                for (int j2 = 1; j2 < this.gridBins - 1; ++j2) {
                    double r = oldVal + newVal;
                    oldVal = newVal;
                    newVal = this.values[i][j2 + 1][k];
                    this.values[i][j2][k] = (r + newVal) / 3.0;
                    content += this.values[i][j2][k];
                }
                this.values[i][this.gridBins - 1][k] = (newVal + oldVal) / 2.0;
                content += this.values[i][this.gridBins - 1][k];
                double dimWeight = 0.0;
                for (int j3 = 0; j3 < this.gridBins; ++j3) {
                    this.weights[j3][k] = 0.0;
                    if (this.values[i][j3][k] > 0.0) {
                        oldVal = content / this.values[i][j3][k];
                        this.weights[j3][k] = Math.pow((oldVal - 1.0) / oldVal / Math.log(oldVal), alpha);
                    }
                    dimWeight += this.weights[j3][k];
                }
                double pointsPerBin = dimWeight / (double)this.gridBins;
                double xOld = 0.0;
                double xNew = 0.0;
                double dw = 0.0;
                int count = 1;
                for (j = 0; j < this.gridBins; ++j) {
                    dw += this.weights[j][k];
                    xOld = xNew;
                    xNew = this.binEdges[i][j + 1][k];
                    while (dw > pointsPerBin) {
                        this.xin[count++] = xNew - (xNew - xOld) * (dw -= pointsPerBin) / this.weights[j][k];
                    }
                }
                for (j = 1; j < this.gridBins; ++j) {
                    this.binEdges[i][j][k] = this.xin[j];
                }
                this.binEdges[i][this.gridBins][k] = 1.0;
            }
        }
    }

    protected void accumulate(int[][] bin, double amount) {
        for (int i = 0; i < this.gridDim; ++i) {
            double[] dArray = this.values[i][bin[i][0]];
            int n = bin[i][1];
            dArray[n] = dArray[n] + amount;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int dimension() {
        return this.gridDim;
    }

    public double volume() {
        return this.gridVol;
    }

    public int nBins() {
        return this.gridBins;
    }

    public int nBoxes() {
        return this.gridBoxes;
    }

    public void setBoxes(int nBoxes) {
        this.gridBoxes = nBoxes;
    }

    public void printBinning() {
        for (int i = 0; i < this.gridDim; ++i) {
            System.out.println("\n**** Dimension " + i + " binning *****");
            for (int j = 0; j < this.dimBlocks[i]; ++j) {
                System.out.println("     For interval " + j);
                System.out.print("       ");
                for (int k = 0; k <= this.gridBins; ++k) {
                    System.out.print("  " + this.binEdges[i][k][j]);
                }
                System.out.println();
            }
        }
    }

    public static void main(String[] args) {
        FunctionFactory ff = new FunctionFactory(null);
        IModelFunction func = (IModelFunction)ff.createFunctionFromScript("threeDdistr", 3, "N*(exp( -(x[0]-mu0)*(x[0]-mu0)/(2*s0*s0) ))*(m*x[1]+2)*(exp(-x[2]/tau)/tau)", "N,mu0,s0,m,tau", "", null);
        IModelFunction func1 = (IModelFunction)ff.createFunctionFromScript("func1", 1, "N*(exp( -(x[0]-mu0)*(x[0]-mu0)/(2*s0*s0) ))", "N,mu0,s0", "", null);
        IModelFunction func2 = (IModelFunction)ff.createFunctionFromScript("func2", 1, "N*(m*x[0]+2)", "N,m", "", null);
        IModelFunction func3 = (IModelFunction)ff.createFunctionFromScript("func3", 1, "N*(exp(-x[0]/tau)/tau)", "N,tau", "", null);
        func.normalizationRange(0).excludeAll();
        func.normalizationRange(1).excludeAll();
        func.normalizationRange(2).excludeAll();
        func.normalizationRange(0).include(0.0, 2.0);
        func.normalizationRange(1).include(3.0, 4.0);
        func.normalizationRange(1).include(6.0, 78.0);
        func.normalizationRange(1).include(109.0, 499.0);
        func.normalizationRange(1).include(3999.0, 4090.0);
        func.normalizationRange(2).include(6.0, 7.8);
        Grid funcGrid = new Grid(func);
        funcGrid.resize(10);
    }
}

