/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.IPlotter;
import hep.aida.IPlotterFactory;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.ref.fitter.Fitter;
import hep.aida.ref.function.FunctionCore;
import hep.aida.ref.function.JELCompiledExpression;
import java.io.IOException;
import java.util.Random;

public class JELFunctionCore
extends FunctionCore {
    private String expression;
    private String gradient;
    private boolean providesGradient;
    private JELCompiledExpression compExpression;
    private JELCompiledExpression[] compGradient;

    public JELFunctionCore(int dim, int nPar, String expr, String[] pNames, String[] gradient) {
        super(dim, nPar);
        if (expr == null || expr.equals("")) {
            throw new IllegalArgumentException("Can not create function from an empty script!");
        }
        this.expression = expr;
        if (pNames != null && nPar != pNames.length) {
            throw new IllegalArgumentException("Number of parameters (" + nPar + ") is different from number of parameter names (" + pNames.length + ")");
        }
        this.compExpression = new JELCompiledExpression(this.dimension, this.numberOfParameters, this.expression, pNames);
        this.compGradient = null;
        if (gradient != null) {
            this.providesGradient = true;
            this.compGradient = new JELCompiledExpression[dim];
            for (int i = 0; i < dim; ++i) {
                this.compGradient[i] = new JELCompiledExpression(this.dimension, this.numberOfParameters, gradient[i], pNames);
            }
        } else {
            this.providesGradient = false;
            this.gradient = null;
        }
        if (pNames != null) {
            this.setParameterNames(pNames);
        }
    }

    public double functionValue(double[] var) {
        return this.compExpression.evaluate(var, this.parameters());
    }

    public boolean setParameterNames(String[] params) {
        super.setParameterNames(params);
        this.compExpression.setParameterNames(params);
        if (this.compGradient != null) {
            for (int i = 0; i < this.dimension; ++i) {
                this.compGradient[i].setParameterNames(params);
            }
        }
        return true;
    }

    public boolean providesGradient() {
        return this.providesGradient;
    }

    public double[] gradient(double[] x) {
        if (this.compGradient == null || !this.providesGradient) {
            throw new UnsupportedOperationException("This function does not provide gradient");
        }
        double[] grad = new double[this.numberOfParameters];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            grad[i] = this.compGradient[i].evaluate(x, this.parameters());
        }
        return grad;
    }

    public boolean providesParameterGradient() {
        return false;
    }

    public double[] parameterGradient(double[] x) {
        throw new UnsupportedOperationException("JELFunctionCore does not provide parameter gradient");
    }

    public boolean providesNormalization() {
        return false;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException("JELFunctionCore does not provide normalization");
    }

    public static void main(String[] args) throws IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ITupleFactory tf = af.createTupleFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IPlotterFactory pf = af.createPlotterFactory();
        IPlotter plotter = pf.create("JAS Plotter");
        plotter.createRegions(2, 1);
        IModelFunction f1 = (IModelFunction)ff.createFunctionFromScript("Script Function 1", 1, "a*(1+c*sin(x[0]-d))", "a,c,d", "f1");
        IModelFunction f2 = (IModelFunction)ff.createFunctionFromScript("Script Function 2", 1, "a*(1+c*sin(x[0]-d))", "a,c,d", "f2");
        IHistogram1D hist1 = hf.createHistogram1D("hist1", "hist1", 100, -5.0, 5.0);
        IHistogram1D hist2 = hf.createHistogram1D("hist2", "hist1", 100, -5.0, 5.0);
        IHistogram2D hist2d = hf.createHistogram2D("hist2d", "hist2d", 100, -5.0, 5.0, 10, -10.0, 0.0);
        Random r = new Random();
        ITuple tup = tf.create("tup", "tup", "double x0, double y");
        for (int i = 0; i < 50000; ++i) {
            double d;
            double x = 10.0 * (r.nextDouble() - 0.5);
            double y = r.nextDouble() * 2.0;
            if (!(y < (d = 1.0 + 0.3 * Math.sin(x - 0.8)))) continue;
            hist1.fill(x);
            hist2.fill(x);
            hist2d.fill(x, y);
            tup.fill(0, x);
            tup.fill(1, y);
            tup.addRow();
        }
        double[] chi2 = new double[]{300.0, 0.5, 1.0};
        f1.setParameters(chi2);
        f2.setParameters(chi2);
        double[] var = new double[1];
        for (int i = -5; i < 5; ++i) {
            var[0] = (double)i * 1.0;
            double d = f1.value(var);
        }
        plotter.currentRegion().plot((IBaseHistogram)hist1);
        plotter.currentRegion().plot((IFunction)f1);
        plotter.currentRegion().plot((IFunction)f1);
        Fitter fitter = new Fitter("Chi2", "minuit", null);
        fitter.fit((IBaseHistogram)hist1, (IFunction)f2);
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist1);
        plotter.currentRegion().plot((IFunction)f2);
        plotter.show();
    }
}

