/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.hbook;

import hep.aida.ITuple;
import hep.aida.ref.hbook.HBookColumnwiseTupleColumn;
import hep.aida.ref.tuple.AbstractTuple;
import hep.io.hbook.ColumnwiseTuple;
import hep.io.hbook.ColumnwiseTupleColumn;
import hep.tuple.Cursor;
import hep.tuple.interfaces.FTuple;
import hep.tuple.interfaces.FTupleColumn;
import hep.tuple.interfaces.FTupleCursor;
import org.freehep.util.Value;

class HBookColumnwiseTuple
extends AbstractTuple
implements FTuple {
    private ColumnwiseTuple tuple;
    private HBookColumnwiseTupleColumn[] columns;
    private Cursor cursor;

    HBookColumnwiseTuple(ColumnwiseTuple tuple) {
        super(String.valueOf(tuple.id()));
        this.setTitle(tuple.getName());
        this.tuple = tuple;
        int nCols = tuple.nChildren();
        this.columns = new HBookColumnwiseTupleColumn[nCols];
        for (int i = 0; i < nCols; ++i) {
            this.columns[i] = new HBookColumnwiseTupleColumn((ColumnwiseTupleColumn)tuple.getChild(i), tuple);
        }
        this.cursor = new Cursor(0, this.rows(), true);
    }

    public double columnMax(int column) throws IllegalArgumentException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(column);
        return child.getMax();
    }

    public double columnMean(int column) throws IllegalArgumentException {
        return Double.NaN;
    }

    public double columnMin(int column) throws IllegalArgumentException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(column);
        return child.getMin();
    }

    public String columnName(int column) throws IllegalArgumentException {
        return this.columns[column].name();
    }

    public String[] columnNames() throws IllegalArgumentException {
        String[] names = new String[this.columns.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.columns[i].name();
        }
        return names;
    }

    public double columnRms(int column) throws IllegalArgumentException {
        return Double.NaN;
    }

    public Class columnType(int column) throws IllegalArgumentException {
        return this.columns[column].type();
    }

    public Class[] columnTypes() throws IllegalArgumentException {
        Class[] types = new Class[this.columns.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.columns[i].type();
        }
        return types;
    }

    public int columns() {
        return this.columns.length;
    }

    public int findColumn(String name) throws IllegalArgumentException {
        int index = this.tuple.getIndex(name);
        if (index < 0) {
            throw new IllegalArgumentException("Column " + name + " does not exist");
        }
        return index;
    }

    public boolean getBoolean(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return child.getBoolean();
    }

    public byte getByte(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return (byte)child.getInt();
    }

    public char getChar(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return (char)child.getInt();
    }

    public double getDouble(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return child.getDouble();
    }

    public float getFloat(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return (float)child.getDouble();
    }

    public int getInt(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return child.getInt();
    }

    public long getLong(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return child.getInt();
    }

    public Object getObject(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return child.getObject();
    }

    public short getShort(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return (short)child.getInt();
    }

    public String getString(int index) throws ClassCastException {
        ColumnwiseTupleColumn child = (ColumnwiseTupleColumn)this.tuple.getChild(index);
        return child.getString();
    }

    public ITuple getTuple(int param) {
        return null;
    }

    public boolean next() {
        boolean advanced = this.cursor.next();
        if (advanced) {
            this.tuple.setCurrentRow(this.cursor.row() + 1);
        }
        return advanced;
    }

    public int rows() {
        return this.tuple.getRows();
    }

    public void setRow(int row) throws IllegalArgumentException {
        if (row < 0 || row >= this.rows()) {
            throw new IllegalArgumentException("Invalid ntuple row: " + row);
        }
        this.tuple.setCurrentRow(row + 1);
    }

    public void skip(int n) throws IllegalArgumentException {
        this.cursor.skip(n);
        this.tuple.setCurrentRow(this.cursor.row() + 1);
    }

    public void start() {
        this.cursor.start();
    }

    public int columnIndexByName(String name) {
        return this.findColumn(name);
    }

    public FTuple tuple(int index) {
        return (FTuple)this.getTuple(index);
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public FTupleColumn column(int index) {
        return this.columns[index];
    }

    public FTupleColumn columnByName(String name) {
        return this.columns[this.columnIndexByName(name)];
    }

    public void columnValue(int column, FTupleCursor cursor, Value value) {
        this.columns[column].value(cursor, value);
    }

    public FTupleCursor cursor() {
        return new Cursor(0, this.rows(), true);
    }

    public void close() {
    }

    public boolean isInMemory() {
        return false;
    }
}

