/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.hbook;

import hep.io.hbook.ColumnwiseTuple;
import hep.io.hbook.ColumnwiseTupleColumn;
import hep.tuple.interfaces.FTupleColumn;
import hep.tuple.interfaces.FTupleCursor;
import org.freehep.util.Value;

public class HBookColumnwiseTupleColumn
implements FTupleColumn {
    private ColumnwiseTupleColumn column;
    private ColumnwiseTuple tuple;
    private Class type;

    HBookColumnwiseTupleColumn(ColumnwiseTupleColumn column, ColumnwiseTuple tuple) {
        this.column = column;
        this.tuple = tuple;
        this.type = column.getColumnClass();
    }

    public String name() {
        return this.column.getName();
    }

    public Class type() {
        return this.type;
    }

    public void minValue(Value value) {
        value.set(this.column.getMin());
    }

    public void maxValue(Value value) {
        value.set(this.column.getMax());
    }

    public void meanValue(Value value) {
        value.set(Double.NaN);
    }

    public void rmsValue(Value value) {
        value.set(Double.NaN);
    }

    public void defaultValue(Value value) {
    }

    public boolean hasDefaultValue() {
        return false;
    }

    public void value(FTupleCursor cursor, Value value) {
        this.tuple.setCurrentRow(cursor.row() + 1);
        if (this.type == Integer.TYPE) {
            value.set(this.column.getInt());
        } else if (this.type == Double.TYPE) {
            value.set(this.column.getDouble());
        } else if (this.type == Boolean.TYPE) {
            value.set(this.column.getBoolean());
        } else if (this.type == String.class) {
            value.set(this.column.getString());
        } else {
            value.set((Object)this.column.getObject());
        }
    }

    public void setValue(int index, Value value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }
}

