/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IBaseStyle;
import hep.aida.ref.plotter.StyleListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class BaseStyle
implements IBaseStyle,
StyleListener {
    private ArrayList parameters = new ArrayList();
    private ArrayList parOptions = new ArrayList();
    private ArrayList parValues = new ArrayList();
    private ArrayList parDefaults = new ArrayList();
    private Hashtable baseStyles = new Hashtable();
    private BaseStyle parent = null;
    private String[] noOptions = new String[0];
    private String name = "plotter";
    private ArrayList listeners = new ArrayList();

    protected BaseStyle() {
        this.initializeBaseStyle();
        this.setParent(null);
    }

    protected BaseStyle(BaseStyle style) {
        this();
        this.copyStyle(this, style);
    }

    private void copyStyle(BaseStyle newStyle, BaseStyle oldStyle) {
        String[] availPars = oldStyle.availableParameters();
        for (int i = 0; i < availPars.length; ++i) {
            Object obj = oldStyle.parameterObject(availPars[i]);
            if (obj == null) continue;
            newStyle.setParameter(availPars[i], (String)obj);
        }
        String[] names = newStyle.baseStyleNames();
        for (int i = 0; i < names.length; ++i) {
            this.copyStyle(newStyle.baseStyle(names[i]), oldStyle.baseStyle(names[i]));
        }
    }

    protected abstract void initializeBaseStyle();

    protected void setName(String name) {
        this.name = name;
    }

    protected String name() {
        return this.name;
    }

    public void setParent(IBaseStyle p) {
        BaseStyle parent;
        this.parent = parent = (BaseStyle)p;
        if (parent != null) {
            Enumeration keys = this.baseStyles.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                this.baseStyle(name).setParent(parent.baseStyle(name));
            }
        }
    }

    public BaseStyle parent() {
        return this.parent;
    }

    protected void addBaseStyle(IBaseStyle baseStyle, String name) {
        BaseStyle bs = (BaseStyle)baseStyle;
        bs.setName(name);
        if (this.baseStyles.get(bs.name()) != null) {
            ((BaseStyle)this.baseStyles.get(bs.name())).removeStyleListener(this);
        }
        this.baseStyles.put(bs.name(), baseStyle);
        bs.addStyleListener(this);
        if (this.parent != null) {
            bs.setParent(this.parent.baseStyle(bs.name()));
        }
        this.notifyStyleChanged();
    }

    private BaseStyle baseStyle(String name) {
        return (BaseStyle)this.baseStyles.get(name);
    }

    private String[] baseStyleNames() {
        String[] names = new String[this.baseStyles.size()];
        Enumeration e = this.baseStyles.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            names[count++] = (String)e.nextElement();
        }
        return names;
    }

    protected void addParameter(String parameterName) {
        this.addParameter(parameterName, null, null);
    }

    protected void addParameter(String parameterName, String defaultValue) {
        this.addParameter(parameterName, null, defaultValue);
    }

    protected void addParameter(String parameterName, String[] options) {
        this.addParameter(parameterName, options, null);
    }

    protected void addParameter(String parameterName, String[] options, String defaultValue) {
        try {
            this.parameterIndex(parameterName);
            throw new IllegalArgumentException("Parameter " + parameterName + " already belongs to this BaseStyle");
        }
        catch (IllegalArgumentException iae) {
            this.parameters.add(parameterName);
            this.parOptions.add(options);
            this.parDefaults.add(defaultValue);
            this.parValues.add(null);
            return;
        }
    }

    private int parameterIndex(String parameterName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!((String)this.parameters.get(i)).toLowerCase().equals(parameterName.toLowerCase())) continue;
            return i;
        }
        throw new IllegalArgumentException("Parameter " + parameterName + " is not part of this Style.");
    }

    private String parameterValue(int parIndex) {
        Object obj = this.parameterObject(parIndex);
        if (obj != null) {
            return (String)obj;
        }
        if (this.parent() == null) {
            return this.parameterDefaultValue(parIndex);
        }
        return this.parent().parameterValue(parIndex);
    }

    protected String parameterDefaultValue(String parameterName) {
        return (String)this.parDefaults.get(this.parameterIndex(parameterName));
    }

    protected String parameterDefaultValue(int parIndex) {
        return (String)this.parDefaults.get(parIndex);
    }

    public String[] availableParameterOptions(String parameterName) {
        int parIndex = this.parameterIndex(parameterName);
        Object obj = this.parOptions.get(parIndex);
        return obj == null ? this.noOptions : (String[])obj;
    }

    public String[] availableParameters() {
        int size = this.parameters.size();
        String[] pars = new String[size];
        for (int i = 0; i < size; ++i) {
            pars[i] = (String)this.parameters.get(i);
        }
        return pars;
    }

    public String parameterValue(String parameterName) {
        int parIndex = this.parameterIndex(parameterName);
        return this.parameterValue(parIndex);
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean sendNotification) {
        this.parValues.clear();
        Enumeration keys = this.baseStyles.keys();
        while (keys.hasMoreElements()) {
            this.baseStyle((String)keys.nextElement()).reset(false);
        }
        if (sendNotification) {
            this.notifyStyleChanged();
        }
    }

    public boolean setParameter(String parameterName) {
        int parIndex = this.parameterIndex(parameterName);
        this.parValues.set(parIndex, null);
        this.notifyStyleChanged();
        return true;
    }

    public boolean setParameter(String parameterName, String parValue) {
        int parIndex = this.parameterIndex(parameterName);
        this.parValues.set(parIndex, parValue);
        this.notifyStyleChanged();
        return true;
    }

    private Object parameterObject(int parIndex) {
        return this.parValues.get(parIndex);
    }

    private Object parameterObject(String parameterName) {
        int parIndex = this.parameterIndex(parameterName);
        return this.parameterObject(parIndex);
    }

    void addStyleListener(StyleListener listener) {
        this.listeners.add(listener);
    }

    void removeStyleListener(StyleListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    void notifyStyleChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            StyleListener listener = (StyleListener)this.listeners.get(i);
            listener.styleChanged(this);
        }
    }

    boolean hasListener(StyleListener listener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (listener != this.listeners.get(i)) continue;
            return true;
        }
        return false;
    }

    public void styleChanged(BaseStyle style) {
        this.notifyStyleChanged();
    }
}

