/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IPlotter;
import hep.aida.IPlotterRegion;
import hep.aida.ITitleStyle;
import hep.aida.ref.plotter.DummyPlotterRegion;
import hep.aida.ref.plotter.TitleStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.freehep.application.PropertyUtilities;
import org.freehep.swing.Headless;
import org.freehep.util.export.ExportFileType;

public class DummyPlotter
implements IPlotter {
    private ArrayList parameters = new ArrayList();
    private ArrayList parOptions = new ArrayList();
    private ArrayList parValues = new ArrayList();
    private ArrayList parDefaults = new ArrayList();
    private ITitleStyle titleStyle = new TitleStyle();
    private static final String[] emptyArray = new String[0];
    private List regions = new ArrayList();
    private int currentRegion = 0;
    static final int DEFAULT_WIDTH = 600;
    static final int DEFAULT_HEIGHT = 600;
    private boolean warned = false;

    protected DummyPlotter() {
        this.initializeParameters();
    }

    DummyPlotter(String name) {
        this.initializeParameters();
        this.createRegion();
    }

    private void initializeParameters() {
        this.addParameter("plotterWidth", String.valueOf(600));
        this.addParameter("plotterHeight", String.valueOf(600));
    }

    protected IPlotterRegion justCreateRegion(double x, double y, double width, double height) {
        return new DummyPlotterRegion(x, y, width, height);
    }

    public void show() {
        System.err.println("Warning: Dummy plotter used, no plot will appear");
    }

    public void hide() {
    }

    public void refresh() {
    }

    public void interact() {
    }

    public IPlotterRegion next() {
        return (IPlotterRegion)this.regions.get(++this.currentRegion);
    }

    public IPlotterRegion createRegion(double x) {
        return this.createRegion(x, 0.0, 1.0 - x, 1.0);
    }

    public IPlotterRegion createRegion() {
        return this.createRegion(0.0, 0.0, 1.0, 1.0);
    }

    public IPlotterRegion createRegion(double x, double y) {
        return this.createRegion(x, y, 1.0 - x, 1.0 - y);
    }

    public IPlotterRegion createRegion(double x, double y, double w) {
        return this.createRegion(x, y, w, 1.0 - y);
    }

    public IPlotterRegion createRegion(double x, double y, double w, double h) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("x");
        }
        if (y < 0.0 || y > 1.0) {
            throw new IllegalArgumentException("y");
        }
        if (w < 0.0 || x + w > 1.0) {
            throw new IllegalArgumentException("w");
        }
        if (h < 0.0 || y + h > 1.0) {
            throw new IllegalArgumentException("h");
        }
        IPlotterRegion region = this.justCreateRegion(x, y, w, h);
        this.regions.add(region);
        return region;
    }

    public IPlotterRegion currentRegion() {
        return (IPlotterRegion)this.regions.get(this.currentRegion);
    }

    public void createRegions() {
        this.createRegions(1, 1, 0);
    }

    public void createRegions(int columns) {
        this.createRegions(columns, 1, 0);
    }

    public void createRegions(int columns, int rows) {
        this.createRegions(columns, rows, 0);
    }

    public void createRegions(int columns, int rows, int start) {
        if (columns <= 0) {
            throw new IllegalArgumentException("columns");
        }
        if (rows <= 0) {
            throw new IllegalArgumentException("rows");
        }
        if (start < 0 || start >= rows * columns) {
            throw new IllegalArgumentException("start");
        }
        this.destroyRegions();
        double width = 1.0 / (double)columns;
        double height = 1.0 / (double)rows;
        for (int i = 0; i < columns; ++i) {
            for (int j = 0; j < rows; ++j) {
                this.regions.add(this.justCreateRegion((double)i * width, (double)j * height, width, height));
            }
        }
        this.currentRegion = start;
    }

    public void setCurrentRegionNumber(int value) {
        if (value < 0 || value >= this.regions.size()) {
            throw new IllegalArgumentException();
        }
        this.currentRegion = value;
    }

    public int currentRegionNumber() {
        return this.currentRegion;
    }

    public IPlotterRegion region(int index) {
        if (index < 0 || index >= this.regions.size()) {
            throw new IllegalArgumentException();
        }
        return (IPlotterRegion)this.regions.get(index);
    }

    public void destroyRegions() {
        this.regions.clear();
    }

    public void clearRegions() {
        Iterator i = this.regions.iterator();
        while (i.hasNext()) {
            ((IPlotterRegion)i.next()).clear();
        }
    }

    public String[] availableParameterOptions(String parameterName) {
        int parIndex = this.parameterIndex(parameterName);
        Object obj = this.parOptions.get(parIndex);
        return obj == null ? emptyArray : (String[])obj;
    }

    public String[] availableParameters() {
        int size = this.parameters.size();
        String[] pars = new String[size];
        for (int i = 0; i < size; ++i) {
            pars[i] = (String)this.parameters.get(i);
        }
        return pars;
    }

    public String parameterValue(String parameterName) {
        int parIndex = this.parameterIndex(parameterName);
        return (String)this.parValues.get(parIndex);
    }

    private int parameterIndex(String parameterName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!((String)this.parameters.get(i)).toLowerCase().equals(parameterName.toLowerCase())) continue;
            return i;
        }
        throw new IllegalArgumentException("Parameter " + parameterName + " is not a plotter parameter.");
    }

    public void setParameter(String name) {
        this.setParameter(name, null);
    }

    public void setParameter(String name, String value) {
        int parIndex = this.parameterIndex(name);
        if (value == null) {
            this.parValues.set(parIndex, this.parDefaults.get(parIndex));
        } else {
            this.parValues.set(parIndex, value);
        }
    }

    public int numberOfRegions() {
        return this.regions.size();
    }

    public ITitleStyle titleStyle() {
        return this.titleStyle;
    }

    public void setTitle(String str) {
    }

    public void setTitleStyle(ITitleStyle iTitleStyle) {
        this.titleStyle = iTitleStyle;
    }

    public void writeToFile(String file) throws IOException {
        this.writeToFile(file, null);
    }

    public void writeToFile(String file, String type) throws IOException {
        System.err.println("Warning: Dummy plotter used, no file will be written");
    }

    public void writeToFile(String fileName, String fileType, Properties props) throws IOException {
        int pos;
        if (fileType == null && (pos = fileName.lastIndexOf(46)) > 0) {
            fileType = fileName.substring(pos + 1);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
        this.writeToFile(out, fileType, props, true);
    }

    void writeToFile(OutputStream out, String type, Properties props) throws IOException {
        this.writeToFile(out, type, props, false);
    }

    void writeToFile(OutputStream out, String type, Properties props, boolean closeOut) throws IOException {
        int delay = 0;
        if (this.isShowing()) {
            delay = 1500;
            if (!this.warned) {
                this.warned = true;
                System.out.println("There might be a synchronization problem when the plotter is being shown and it is written to file.\nPlease refer to the JAIDA release notes for more details: http://java.freehep.org/jaida.\nTo avoid this problem don't invoke the show() method on the Plotter when writing to file.");
            }
        }
        WriteToFile writeToFile = new WriteToFile(this.panel(), this.isShowing(), out, type, props, closeOut);
        if (this.isShowing()) {
            WriteToFileActionListener actionListener = new WriteToFileActionListener(writeToFile, this.isShowing());
            Timer timer = new Timer(delay, actionListener);
            timer.setRepeats(false);
            timer.start();
        } else {
            writeToFile.run();
        }
    }

    public boolean isShowing() {
        return false;
    }

    public JPanel panel() {
        return null;
    }

    protected int plotterWidth() {
        return Integer.parseInt(this.parameterValue("plotterWidth"));
    }

    protected int plotterHeight() {
        return Integer.parseInt(this.parameterValue("plotterHeight"));
    }

    public static void invokeOnSwingThread(Runnable run) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeAndWait(run);
            }
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
        }
        catch (InterruptedException x) {
            x.printStackTrace();
        }
    }

    protected void addParameter(String parameterName) {
        this.addParameter(parameterName, null, null);
    }

    protected void addParameter(String parameterName, String defaultValue) {
        this.addParameter(parameterName, null, defaultValue);
    }

    protected void addParameter(String parameterName, String[] options) {
        this.addParameter(parameterName, options, null);
    }

    protected void addParameter(String parameterName, String[] options, String defaultValue) {
        try {
            this.parameterIndex(parameterName);
            throw new IllegalArgumentException("Parameter " + parameterName + " already belongs to this BaseStyle");
        }
        catch (IllegalArgumentException iae) {
            this.parameters.add(parameterName);
            this.parOptions.add(options);
            this.parDefaults.add(defaultValue);
            this.parValues.add(defaultValue);
            return;
        }
    }

    private class WriteToFile
    implements Runnable {
        private JPanel panel;
        private boolean isShowing;
        private OutputStream out;
        private String fileType;
        private Properties props;
        private boolean closeOut;

        WriteToFile(JPanel panel, boolean showing, OutputStream out, String type, Properties props, boolean closeOut) {
            this.panel = panel;
            this.isShowing = showing;
            this.out = out;
            this.fileType = type;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Headless headLess = null;
            if (!this.isShowing) {
                headLess = new Headless((JComponent)this.panel);
                int width = this.props == null ? 600 : PropertyUtilities.getInteger((Properties)this.props, (String)"plotWidth", (int)600);
                int height = this.props == null ? 600 : PropertyUtilities.getInteger((Properties)this.props, (String)"plotHeight", (int)600);
                this.panel.setPreferredSize(new Dimension(width, height));
                headLess.pack();
                headLess.setVisible(true);
            }
            try {
                List types = ExportFileType.getExportFileTypes((String)this.fileType);
                if (types == null || types.size() == 0) {
                    throw new IllegalArgumentException("Unsupported file type: " + this.fileType);
                }
                ExportFileType fType = (ExportFileType)types.get(0);
                try {
                    fType.exportToFile(this.out, (Component)this.panel, null, this.props, "AIDA");
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            finally {
                if (headLess != null) {
                    headLess.dispose();
                }
            }
            if (this.closeOut) {
                try {
                    this.out.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe.getMessage());
                }
            }
        }
    }

    private class WriteToFileActionListener
    implements ActionListener {
        private WriteToFile writeToFile;
        private boolean isShowing;

        WriteToFileActionListener(WriteToFile writeToFile, boolean isShowing) {
            this.writeToFile = writeToFile;
            this.isShowing = isShowing;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isShowing) {
                DummyPlotter.invokeOnSwingThread(this.writeToFile);
            } else {
                this.writeToFile.run();
            }
        }
    }
}

