/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IPlotterRegion;
import hep.aida.ref.plotter.DummyPlotter;
import hep.aida.ref.plotter.PlotterRegion;
import jas.util.layout.PercentLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Plotter
extends DummyPlotter {
    private String name;
    private boolean isShowing = false;
    private JPanel panel;

    protected Plotter(String name) {
        this.name = name;
        this.panel = this.createPanel();
        this.configurePanel(this.panel);
        this.createRegion();
    }

    protected JPanel createPanel() {
        return new JPanel();
    }

    protected PlotterRegion createPlotterRegion() {
        return new PlotterRegion();
    }

    protected void configurePanel(JPanel panel) {
        panel.setLayout((LayoutManager)new PercentLayout());
        panel.setBackground(Color.white);
        panel.setPreferredSize(new Dimension(this.plotterWidth(), this.plotterHeight()));
    }

    protected JPanel getPanel() {
        this.panel.setPreferredSize(new Dimension(this.plotterWidth(), this.plotterHeight()));
        return this.panel;
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public JPanel panel() {
        return this.getPanel();
    }

    protected String getTitle() {
        return this.name;
    }

    public void show() {
        if (!this.isShowing) {
            JFrame frame = new JFrame(this.name);
            frame.setContentPane(this.panel());
            frame.setDefaultCloseOperation(2);
            frame.pack();
            frame.setVisible(true);
            this.isShowing = true;
        }
    }

    public void hide() {
        if (this.isShowing) {
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.panel());
            if (frame != null) {
                frame.dispose();
            }
            this.isShowing = false;
        }
    }

    protected IPlotterRegion justCreateRegion(double x, double y, double width, double height) {
        CreateRegion cr = new CreateRegion(x, y, width, height);
        Plotter.invokeOnSwingThread(cr);
        return cr.getRegion();
    }

    public void destroyRegions() {
        Plotter.invokeOnSwingThread(new DestroyRegions());
        super.destroyRegions();
    }

    public void writeToFile(String file, String type) throws IOException {
        this.writeToFile(file, type, System.getProperties());
    }

    private class DestroyRegions
    implements Runnable {
        private DestroyRegions() {
        }

        public void run() {
            Plotter.this.panel.removeAll();
            Plotter.this.panel.repaint();
        }
    }

    private class CreateRegion
    implements Runnable {
        private double x;
        private double y;
        private double width;
        private double height;
        private PlotterRegion region;

        CreateRegion(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void run() {
            this.region = Plotter.this.createPlotterRegion();
            Plotter.this.panel.add((Component)this.region.getPanel(), new PercentLayout.Constraint(this.x * 100.0, this.y * 100.0, this.width * 100.0, this.height * 100.0));
        }

        IPlotterRegion getRegion() {
            return this.region;
        }
    }
}

