/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IAxisStyle;
import hep.aida.IBaseStyle;
import hep.aida.IDataStyle;
import hep.aida.IInfoStyle;
import hep.aida.IPlotterStyle;
import hep.aida.ITitleStyle;
import hep.aida.ref.plotter.AxisStyle;
import hep.aida.ref.plotter.BaseStyle;
import hep.aida.ref.plotter.DataStyle;
import hep.aida.ref.plotter.InfoStyle;
import hep.aida.ref.plotter.TitleStyle;

public class PlotterStyle
extends BaseStyle
implements IPlotterStyle {
    private IDataStyle dataStyle;
    private IInfoStyle infoStyle;
    private ITitleStyle titleStyle;
    private IAxisStyle xAxisStyle;
    private IAxisStyle yAxisStyle;
    private IAxisStyle zAxisStyle;

    PlotterStyle() {
    }

    PlotterStyle(PlotterStyle style) {
        super(style);
    }

    protected void initializeBaseStyle() {
        this.dataStyle = new DataStyle();
        this.infoStyle = new InfoStyle();
        this.titleStyle = new TitleStyle();
        this.xAxisStyle = new AxisStyle();
        this.yAxisStyle = new AxisStyle();
        this.zAxisStyle = new AxisStyle();
        this.addBaseStyle((IBaseStyle)this.dataStyle, "data");
        this.addBaseStyle((IBaseStyle)this.infoStyle, "info");
        this.addBaseStyle((IBaseStyle)this.titleStyle, "title");
        this.addBaseStyle((IBaseStyle)this.xAxisStyle, "xAxis");
        this.addBaseStyle((IBaseStyle)this.yAxisStyle, "yAxis");
        this.addBaseStyle((IBaseStyle)this.zAxisStyle, "zAxis");
        String[] trueFalse = new String[]{"true", "false"};
        this.addParameter("showStatisticsBox", trueFalse, "true");
        this.addParameter("showLegend", trueFalse, "true");
        this.addParameter("legendFont", "SansSerif");
        this.addParameter("legendFontSize", "10");
        this.addParameter("legendFontStyle", "1");
        this.addParameter("legendTitles");
        this.addParameter("statisticsBoxFont", "SansSerif");
        this.addParameter("statisticsBoxFontSize", "10");
        this.addParameter("statisticsBoxFontStyle", "1");
        this.addParameter("backgroundColor");
        this.addParameter("foregroundColor");
        this.addParameter("dataAreaColor");
        String[] borderTypes = new String[]{"bevelIn", "bevelOut", "etched", "line", "shadow", "0", "1", "2", "3", "4"};
        this.addParameter("dataAreaBorderType", borderTypes);
        String[] hist2dStyle = new String[]{"box", "ellipse", "colorMap", "0", "1", "2"};
        this.addParameter("hist2DStyle", hist2dStyle);
        this.addParameter("showAsScatterPlot", trueFalse, "true");
        this.addParameter("showTitle", trueFalse, "true");
    }

    public IDataStyle dataStyle() {
        return this.dataStyle;
    }

    public IInfoStyle infoStyle() {
        return this.infoStyle;
    }

    public ITitleStyle titleStyle() {
        return this.titleStyle;
    }

    public IAxisStyle xAxisStyle() {
        return this.xAxisStyle;
    }

    public IAxisStyle yAxisStyle() {
        return this.yAxisStyle;
    }

    public IAxisStyle zAxisStyle() {
        return this.zAxisStyle;
    }

    public boolean setAxisStyleX(IAxisStyle xAxisStyle) {
        this.xAxisStyle = xAxisStyle;
        this.addBaseStyle((IBaseStyle)xAxisStyle, "xAxis");
        return true;
    }

    public boolean setAxisStyleY(IAxisStyle yAxisStyle) {
        this.yAxisStyle = yAxisStyle;
        this.addBaseStyle((IBaseStyle)yAxisStyle, "yAxis");
        return true;
    }

    public boolean setAxisStyleZ(IAxisStyle zAxisStyle) {
        this.zAxisStyle = zAxisStyle;
        this.addBaseStyle((IBaseStyle)zAxisStyle, "zAxis");
        return true;
    }

    public boolean setDataStyle(IDataStyle dataStyle) {
        this.dataStyle = dataStyle;
        this.addBaseStyle((IBaseStyle)dataStyle, "data");
        return true;
    }

    public boolean setInfoStyle(IInfoStyle infoStyle) {
        this.infoStyle = infoStyle;
        this.addBaseStyle((IBaseStyle)infoStyle, "info");
        return true;
    }

    public boolean setTitleStyle(ITitleStyle titleStyle) {
        this.titleStyle = titleStyle;
        this.addBaseStyle((IBaseStyle)titleStyle, "title");
        return true;
    }
}

