/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IManagedObject;
import hep.aida.dev.IDevMutableStore;
import hep.aida.dev.IDevTree;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.Annotation;
import hep.aida.ref.remote.RemoteClient;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteTree;
import hep.aida.ref.remote.RemoteUnavailableObject;
import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.interfaces.AidaUpdatable;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RemoteMutableStore
implements AidaUpdatable,
IDevMutableStore {
    protected IDevTree tree;
    protected RemoteClient client;
    protected boolean initDone;
    protected boolean recursive;
    protected RemoteUpdateEvent[] events;
    protected Logger remoteLogger;
    protected boolean hurry;

    public RemoteMutableStore() {
        this(false);
    }

    public RemoteMutableStore(boolean hurry) {
        this(null, null, hurry);
    }

    public RemoteMutableStore(IDevTree tree) {
        this(tree, null, false);
    }

    public RemoteMutableStore(IDevTree tree, boolean hurry) {
        this(tree, null, hurry);
    }

    private RemoteMutableStore(IDevTree tree, RemoteClient client, boolean hurry) {
        this.tree = tree;
        this.client = client;
        this.hurry = hurry;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.init();
    }

    public void init() {
        this.recursive = true;
        this.events = new RemoteUpdateEvent[1];
        this.initDone = false;
    }

    public void setHurry(boolean hurry) {
        this.hurry = hurry;
        this.remoteLogger.fine("RemoteMutableStore.setHurry  to " + hurry);
    }

    public void handleDataUpdate(IManagedObject mo, String path, String type) throws IllegalArgumentException {
        if (this.hurry) {
            RemoteUpdateEvent evt = new RemoteUpdateEvent(10, path, type);
            AidaUpdateEvent[] eventArray = new RemoteUpdateEvent[]{evt};
            if (this.client != null) {
                this.client.stateChanged(eventArray);
                if (mo instanceof RemoteManagedObject) {
                    ((RemoteManagedObject)mo).setDataValid(true);
                }
            } else {
                this.updateData(path, type);
            }
        } else {
            this.updateData(path, type);
        }
    }

    protected abstract RemoteClient createClient(Map var1);

    public abstract void updateData(String var1, String var2) throws IllegalArgumentException;

    public abstract IManagedObject createObject(String var1, String var2) throws IllegalArgumentException;

    public void close() throws IOException {
        this.client.disconnect();
        this.client = null;
        this.tree = null;
        this.events = null;
    }

    public void commit(IDevTree tree, Map options) throws IOException {
        throw new UnsupportedOperationException("Can not commit changes to the Read-Only Store");
    }

    public boolean isReadOnly() {
        return true;
    }

    public void read2(IDevTree tree, String path) throws IllegalArgumentException, IOException {
        if (this.tree == null) {
            this.tree = tree;
        }
        if (!this.client.isConnected()) {
            throw new IOException("Can not read from the Store: client is not connected!");
        }
        this.remoteLogger.finest("RemoteMutableStore.read: path=" + path + ", recursive=" + this.recursive);
        String[] names = this.client.listObjectNames(path);
        String[] types = this.client.listObjectTypes(path);
        if (names != null && types != null) {
            for (int i = 0; i < names.length; ++i) {
                this.events[0] = new RemoteUpdateEvent(1, names[i], types[i]);
                this.client.stateChanged(this.events);
                if (!this.recursive || !types[i].equalsIgnoreCase("dir")) continue;
                this.read2(tree, names[i]);
            }
            this.events[0] = new RemoteUpdateEvent(5, path, "dir");
            this.client.stateChanged(this.events);
        }
    }

    public void read(IDevTree tree, String path) throws IllegalArgumentException, IOException {
        if (this.tree == null) {
            this.tree = tree;
        }
        if (!this.client.isConnected()) {
            throw new IOException("Can not read from the Store: client is not connected!");
        }
        this.remoteLogger.finest("RemoteMutableStore.read: path=" + path + ", recursive=" + this.recursive);
        String[] names = null;
        String[] types = null;
        names = this.client.listObjectNames(path);
        types = this.client.listObjectTypes(path);
        if (names != null && types != null) {
            int i;
            for (i = 0; i < names.length; ++i) {
                String typeString;
                int id = 1;
                String pathString = names[i];
                String type = typeString = types[i];
                String xType = "double";
                int indexT = typeString.lastIndexOf(":");
                if (indexT > 0) {
                    type = typeString.substring(0, indexT);
                    String tmpType = typeString.substring(indexT + 1);
                    if (tmpType != null && !tmpType.equals("")) {
                        xType = tmpType;
                    }
                }
                this.executeStateChanged(id, pathString, type, xType);
            }
            tree.hasBeenFilled(path);
            if (this.recursive) {
                for (i = 0; i < names.length; ++i) {
                    if (!types[i].equalsIgnoreCase("dir") && !types[i].equalsIgnoreCase("mnt")) continue;
                    this.read(tree, names[i]);
                }
            }
        }
    }

    public void read(IDevTree tree, Map options, boolean readOnly, boolean createNew) throws IOException {
        if (this.tree == null) {
            this.tree = tree;
        }
        if (this.client == null) {
            this.client = this.createClient(options);
        }
        if (!this.client.isConnected()) {
            this.client.connect();
        }
        this.recursive = options.containsKey("recursive");
        this.initDone = false;
        this.remoteLogger.fine("RemoteMutableStore.read: initial read for the top directory, recursive=" + this.recursive);
        this.read(tree, "/");
        this.initDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(AidaUpdateEvent event) {
        Object lock = this.tree.getLock();
        this.remoteLogger.finest("RemoteMutableStore.stateChanged for EVENT:: id=" + event.id() + ", path=" + event.path() + ",  type=" + event.nodeType());
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                this.executeStateChanged(event);
            }
        } else {
            this.executeStateChanged(event);
        }
    }

    protected void executeStateChanged(AidaUpdateEvent event) {
        String tmp;
        String typeString;
        int id = event.id();
        String path = event.path();
        String type = typeString = event.nodeType();
        String xType = "double";
        int indexT = typeString.lastIndexOf(":");
        if (indexT > 0) {
            type = typeString.substring(0, indexT);
            String tmpType = typeString.substring(indexT + 1);
            if (tmpType != null && !tmpType.equals("")) {
                xType = tmpType;
            }
        } else if (event instanceof RemoteUpdateEvent && (tmp = ((RemoteUpdateEvent)event).getXAxisType()) != null) {
            xType = tmp;
        }
        this.executeStateChanged(id, path, type, xType);
        this.remoteLogger.finest("RemoteMutableStore.executeStateChanged for EVENT:: id=" + id + ", path=" + path + ",  type=" + type + ", xAxisType=" + xType);
        if (this.tree instanceof RemoteTree && id != 0) {
            ((RemoteTree)this.tree).submitEventToListeners(event);
        }
    }

    protected void executeStateChanged(int id, String path, String type, String xType) {
        block70: {
            Object lock = this.tree.getLock();
            this.remoteLogger.finest("RemoteMutableStore.executeStateChanged:: id=" + id + ", path=" + path + ",  type=" + type + ", xAxisType=" + xType + ",  lock=" + lock);
            if (id == 1) {
                try {
                    if (type.equalsIgnoreCase("dir") || type.equalsIgnoreCase("mnt")) {
                        if (this.tree instanceof RemoteTree) {
                            ((RemoteTree)this.tree).addFolder(path);
                            try {
                                if (this.initDone) {
                                    this.read(this.tree, path);
                                }
                                break block70;
                            }
                            catch (Exception e) {
                                this.remoteLogger.log(Level.INFO, "RemoteMutableStore.stateChanged: Exception while adding node: " + type + ", " + path + ", Skip this.", e);
                                this.remoteLogger.log(Level.FINEST, "RemoteMutableStore.stateChanged: Exception while adding node: " + type + ", " + path + ", Skip this.", e.getStackTrace());
                            }
                            break block70;
                        }
                        this.tree.mkdirs(path);
                        break block70;
                    }
                    if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if (path.endsWith("/")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    String name = AidaUtils.parseName(path);
                    String objDir = AidaUtils.parseDirName(path);
                    RemoteUnavailableObject h = null;
                    if (this.tree instanceof RemoteTree) {
                        ((RemoteTree)this.tree).addFolder(objDir);
                    } else {
                        this.tree.mkdirs(objDir);
                    }
                    h = type.equals("RemoteUnavailableObject") ? new RemoteUnavailableObject(name) : this.createObject(name, type);
                    if (h instanceof RemoteManagedObject) {
                        RemoteManagedObject r = h;
                        r.setFillable(true);
                        if (h instanceof IBaseHistogram) {
                            Annotation a = (Annotation)((IBaseHistogram)h).annotation();
                            a.setFillable(true);
                            try {
                                a.setValue("xAxisType", xType);
                            }
                            catch (IllegalArgumentException e) {
                                a.addItem("xAxisType", xType);
                            }
                            a.setFillable(false);
                        } else if (h instanceof IDataPointSet) {
                            Annotation a = (Annotation)((IDataPointSet)h).annotation();
                            a.setFillable(true);
                            try {
                                a.setValue("xAxisType", xType);
                            }
                            catch (IllegalArgumentException e) {
                                a.addItem("xAxisType", xType);
                            }
                            a.setFillable(false);
                        }
                        r.setFillable(false);
                    }
                    if (this.tree instanceof RemoteTree) {
                        ((RemoteTree)this.tree).addObject(objDir, (IManagedObject)h);
                    } else {
                        this.tree.add(objDir, (IManagedObject)h);
                    }
                    if (h instanceof RemoteManagedObject) {
                        ((RemoteManagedObject)h).setTreeFolder(objDir);
                        if (h instanceof RemoteUnavailableObject) {
                            ((RemoteManagedObject)h).setDataValid(true);
                        } else {
                            ((RemoteManagedObject)h).setDataValid(false);
                        }
                        break block70;
                    }
                    this.handleDataUpdate((IManagedObject)h, path, type);
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.stateChanged: IllegalArgumentException while ADDING node. Skip this: \n\t" + ex.getMessage());
                    this.remoteLogger.log(Level.FINEST, "", ex);
                }
            } else if (id == 5) {
                if (type.equalsIgnoreCase("dir")) {
                    this.tree.hasBeenFilled(path);
                }
            } else if (id == 2) {
                try {
                    if (type.equalsIgnoreCase("dir")) {
                        if (this.tree instanceof RemoteTree) {
                            ((RemoteTree)this.tree).removeFolder(path);
                        } else {
                            this.tree.rmdir(path);
                        }
                        break block70;
                    }
                    if (this.tree instanceof RemoteTree) {
                        ((RemoteTree)this.tree).removeObject(path);
                        break block70;
                    }
                    this.tree.rm(path);
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.stateChanged: IllegalArgumentException while DELETING node. Skip this.", ex);
                }
            } else if (id == 0) {
                try {
                    IManagedObject h = null;
                    h = this.tree instanceof RemoteTree ? ((RemoteTree)this.tree).executeFind(path) : this.tree.find(path);
                    if (h instanceof RemoteManagedObject) {
                        ((RemoteManagedObject)h).setDataValid(false);
                        break block70;
                    }
                    this.handleDataUpdate(h, path, type);
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.stateChanged: IllegalArgumentException while UPDATING node. Skip this.", ex);
                }
            } else if (id == 10) {
                this.updateData(path, type);
            } else if (id == 20) {
                try {
                    if (type.equalsIgnoreCase("dir")) {
                        if (this.tree instanceof RemoteTree) {
                            ((RemoteTree)this.tree).removeFolder(path);
                        } else {
                            this.tree.rmdir(path);
                        }
                    } else {
                        if (this.tree instanceof RemoteTree) {
                            ((RemoteTree)this.tree).removeObject(path);
                        }
                        this.tree.rm(path);
                    }
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.stateChanged: IllegalArgumentException while DELETING node. Skip this.", ex);
                }
                String name = AidaUtils.parseName(path);
                String objDir = AidaUtils.parseDirName(path);
                RemoteUnavailableObject h = new RemoteUnavailableObject(name);
                if (this.tree instanceof RemoteTree) {
                    ((RemoteTree)this.tree).addObject(objDir, (IManagedObject)h);
                } else {
                    this.tree.add(objDir, (IManagedObject)h);
                }
                h.setTreeFolder(objDir);
                h.setDataValid(true);
            } else if (id == 21) {
                try {
                    IManagedObject obj = null;
                    obj = this.tree instanceof RemoteTree ? ((RemoteTree)this.tree).executeFind(path) : this.tree.find(path);
                    if (obj != null) {
                        if (this.tree instanceof RemoteTree) {
                            ((RemoteTree)this.tree).removeObject(path);
                        } else {
                            this.tree.rm(path);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteMutableStore.stateChanged: IllegalArgumentException while DELETING node. Skip this.", ex);
                }
                if (type.equalsIgnoreCase("dir")) {
                    if (this.tree instanceof RemoteTree) {
                        ((RemoteTree)this.tree).addFolder(path);
                    } else {
                        this.tree.mkdirs(path);
                    }
                    if (this.recursive) {
                        try {
                            this.read(this.tree, path);
                        }
                        catch (Exception ioe) {
                            this.remoteLogger.log(Level.INFO, "RemoteMutableStore.stateChanged: Exception while updating PATH=" + path, ioe);
                            this.remoteLogger.log(Level.FINE, "", ioe.getStackTrace());
                        }
                    }
                } else {
                    RemoteUpdateEvent evt = new RemoteUpdateEvent(1, path, type);
                    AidaUpdateEvent[] eventArray = new RemoteUpdateEvent[]{evt};
                    if (this.client != null) {
                        this.client.stateChanged(eventArray);
                    }
                }
            } else {
                this.remoteLogger.log(Level.INFO, "RemoteMutableStore.stateChanged: Wrong ID=" + id + ", path=" + path + ",  type=" + type);
            }
        }
    }

    public static void main(String[] args) {
    }

    public class ReadThread
    extends Thread {
        private String readPath;
        private long wait;

        public ReadThread(String readPath) {
            this(readPath, 0L);
        }

        public ReadThread(String readPath, long wait) {
            this.readPath = readPath;
            this.wait = wait;
        }

        public void run() {
            try {
                if (this.wait > 0L) {
                    Thread.sleep(this.wait);
                }
                RemoteMutableStore.this.read(RemoteMutableStore.this.tree, this.readPath);
            }
            catch (InterruptedException e2) {
                RemoteMutableStore.this.remoteLogger.log(Level.INFO, "RemoteMutableStore InterruptedException.", e2);
                RemoteMutableStore.this.remoteLogger.log(Level.FINE, "", e2.getStackTrace());
            }
            catch (Exception e3) {
                RemoteMutableStore.this.remoteLogger.log(Level.INFO, "Exception in RemoteMutableStore: ", e3);
                RemoteMutableStore.this.remoteLogger.log(Level.FINE, "", e3.getStackTrace());
            }
        }
    }
}

