/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteServerQueue
implements Runnable {
    protected AidaTreeClient client;
    protected List queue = new ArrayList(100);
    protected List holdQueue = new ArrayList(100);
    protected boolean keepRunning = true;
    protected boolean hold;
    protected Logger remoteLogger;

    public RemoteServerQueue() {
        this(null);
    }

    public RemoteServerQueue(AidaTreeClient client) {
        this.client = client;
        this.hold = false;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.remoteLogger.fine("RemoteServerQueue: START");
        if (client != null) {
            new Thread(this).start();
        }
    }

    public synchronized void close() {
        this.keepRunning = false;
        this.queue.clear();
        this.holdQueue.clear();
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHold(boolean h) {
        if (h) {
            this.hold = h;
        } else {
            RemoteServerQueue remoteServerQueue = this;
            synchronized (remoteServerQueue) {
                this.hold = h;
                this.queue.addAll(this.holdQueue);
                this.holdQueue.clear();
                this.notify();
            }
        }
    }

    public int size() {
        return this.queue == null ? 0 : this.queue.size();
    }

    public void schedule(AidaUpdateEvent event) {
        this.remoteLogger.finest("RemoteServerQueue.schedule id=" + event.id() + ", path=" + event.path() + ", type=" + event.nodeType());
        if (this.keepRunning) {
            this.addToQueue(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AidaUpdateEvent[] getEvents() {
        AidaUpdateEvent[] events = new AidaUpdateEvent[]{};
        int size = this.size();
        if (size == 0) {
            return events;
        }
        RemoteServerQueue remoteServerQueue = this;
        synchronized (remoteServerQueue) {
            size = this.queue.size();
            events = new AidaUpdateEvent[size];
            this.queue.toArray(events);
            this.queue.clear();
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToQueue(AidaUpdateEvent event) {
        RemoteServerQueue remoteServerQueue = this;
        synchronized (remoteServerQueue) {
            if (this.hold) {
                this.holdQueue.add(event);
            } else {
                this.queue.add(event);
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int size = 0;
        AidaUpdateEvent[] events = null;
        while (this.keepRunning) {
            try {
                RemoteServerQueue remoteServerQueue = this;
                synchronized (remoteServerQueue) {
                    if (this.queue.size() == 0) {
                        this.wait();
                    }
                    if (this.queue == null) {
                        return;
                    }
                    size = this.queue.size();
                    if (size > 0) {
                        events = this.getEvents();
                    }
                }
                this.remoteLogger.finest("RemoteServerQueue.run Processing: " + size);
                if (events == null && events.length <= 0 || this.client == null) continue;
                this.client.stateChanged(events);
            }
            catch (InterruptedException e2) {
                this.remoteLogger.log(Level.INFO, "RemoteServerOueue InterruptedException.", e2);
                this.remoteLogger.log(Level.FINE, "", e2.getStackTrace());
            }
            catch (Exception e3) {
                this.remoteLogger.log(Level.INFO, "Exception in RemoteServerQueue: ", e3);
                this.remoteLogger.log(Level.FINE, "", e3.getStackTrace());
            }
        }
    }
}

