/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.basic;

import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.remote.basic.UpdatableQueue;
import hep.aida.ref.remote.basic.interfaces.AidaConnectionException;
import hep.aida.ref.remote.basic.interfaces.AidaTreeClient;
import hep.aida.ref.remote.basic.interfaces.AidaTreeServant;
import hep.aida.ref.remote.basic.interfaces.AidaTreeServer;
import hep.aida.ref.remote.basic.interfaces.UpdateEvent;

public class BasicTreeClient
implements AidaTreeClient,
Runnable {
    protected AidaTreeServer server;
    protected AidaTreeServant servant;
    protected IDevMutableStore store;
    protected UpdatableQueue queue;
    protected boolean duplex;
    protected boolean isConnected;
    protected int updateInterval;
    protected boolean keepUpdating;
    protected String clientID;
    private AidaTreeServer testServer;

    public BasicTreeClient() {
        this(null, true);
    }

    public BasicTreeClient(IDevMutableStore store) {
        this(store, true);
    }

    public BasicTreeClient(IDevMutableStore store, boolean duplex) {
        this.init();
        this.store = store;
        this.duplex = duplex;
        this.keepUpdating = !duplex;
        this.queue = new UpdatableQueue();
    }

    BasicTreeClient(IDevMutableStore store, boolean duplex, AidaTreeServer server) {
        this.init();
        this.store = store;
        this.duplex = duplex;
        this.keepUpdating = !duplex;
        this.testServer = server;
    }

    protected void init() {
        this.server = null;
        this.servant = null;
        this.isConnected = false;
        this.updateInterval = 2000;
        this.clientID = "AidaTreeClient";
    }

    protected AidaTreeServer getServer() {
        return this.testServer;
    }

    public synchronized void setUpdateTime(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public synchronized void setDuplex(boolean duplex) {
        if (this.isConnected) {
            System.out.println("WARNING: Client is connected, can not change DUPLEX settings. Please disconnect first");
            return;
        }
        this.duplex = duplex;
        this.keepUpdating = !duplex;
    }

    protected void connectDuplex() throws AidaConnectionException {
        this.servant = this.server.connectDuplex(this);
        if (this.servant == null) {
            throw new AidaConnectionException("Can not retrieve non-Duplex AidaTreeServant from: " + this.server.treeName());
        }
        this.isConnected = true;
    }

    protected void connectNonDuplex() throws AidaConnectionException {
        this.servant = this.server.connectNonDuplex(this.clientID);
        if (this.servant == null) {
            throw new AidaConnectionException("Can not retrieve non-Duplex AidaTreeServant from: " + this.server.treeName());
        }
        new Thread(this).start();
        this.isConnected = true;
    }

    public String[] listObjectNames(String path) throws IllegalArgumentException {
        if (!this.isConnected) {
            System.out.println("WARNING: Client is not connected.");
            return null;
        }
        String[] names = this.servant.listObjectNames(path);
        return names;
    }

    public String[] listObjectTypes(String path) throws IllegalArgumentException {
        if (!this.isConnected) {
            System.out.println("WARNING: Client is not connected.");
            return null;
        }
        String[] types = this.servant.listObjectTypes(path);
        return types;
    }

    public Object find(String path) throws IllegalArgumentException {
        if (!this.isConnected) {
            System.out.println("WARNING: Client is not connected.");
            return null;
        }
        Object obj = this.servant.find(path);
        return obj;
    }

    public void stateChanged(UpdateEvent[] events) {
        if (events != null && events.length > 0) {
            for (int i = 0; i < events.length; ++i) {
                this.queue.schedule(this.store, events[i]);
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean connect() throws AidaConnectionException {
        if (this.isConnected) {
            String name = "null";
            if (this.server != null) {
                name = this.server.treeName();
            }
            System.out.println("WARNING: Already connected to AidaTreeServer: " + name);
            return false;
        }
        this.queue = new UpdatableQueue();
        this.server = this.getServer();
        System.out.println("Connecting:  duplex=" + this.duplex);
        if (this.server == null) {
            throw new AidaConnectionException("Can not get reference to AidaTreeServer.");
        }
        try {
            if (this.duplex) {
                boolean supportsDuplex = this.server.supportDuplexMode();
                if (!supportsDuplex) {
                    System.out.println("Warning: AidaTreeServer \"" + this.server.treeName() + "\" does not support DUPLEX mode. \nWill try to connect using non-DUPLEX mode.");
                    this.duplex = false;
                    this.keepUpdating = !this.duplex;
                    this.connectNonDuplex();
                } else {
                    this.connectDuplex();
                }
            } else {
                this.connectNonDuplex();
            }
        }
        catch (AidaConnectionException ae) {
            throw ae;
        }
        catch (Exception e) {
            String name = "null";
            if (this.server != null) {
                name = this.server.treeName();
            }
            throw new AidaConnectionException("Can not connect to AidaTreeServer: " + name, e);
        }
        return true;
    }

    public boolean disconnect() {
        System.out.print("\nBasicTreeClient.disconnect: for Client=" + this.clientID + " ... ");
        this.queue.close();
        this.queue = null;
        if (!this.isConnected) {
            this.keepUpdating = false;
            this.server = null;
            this.servant = null;
            return true;
        }
        boolean status = true;
        this.keepUpdating = false;
        if (this.server != null) {
            status = this.duplex ? this.server.disconnectDuplex(this) : this.server.disconnectNonDuplex(this.clientID);
        }
        this.server = null;
        this.servant = null;
        System.out.print(" Done.\n");
        return status;
    }

    public void run() {
        while (this.keepUpdating) {
            UpdateEvent[] events;
            if (this.isConnected && (events = this.servant.updates()) != null && events.length > 0) {
                this.stateChanged(events);
            }
            try {
                Thread.sleep(this.updateInterval);
            }
            catch (InterruptedException ie) {
                System.out.println("AidaTreeClient non-DUPLEX Update Thread InterruptedException.");
                ie.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
    }
}

