/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.corba;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IManagedObject;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.DataPointSetEvent;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.event.TreeEvent;
import hep.aida.ref.remote.corba.CorbaServerEventQueue;
import hep.aida.ref.remote.corba.converters.CorbaConverter;
import hep.aida.ref.remote.corba.generated.EventFlags;
import hep.aida.ref.remote.corba.generated.EventID;
import hep.aida.ref.remote.corba.generated.EventStruct;
import hep.aida.ref.remote.corba.generated.TreeClient;
import hep.aida.ref.remote.corba.generated.TreeServantPOA;
import hep.aida.ref.tree.Tree;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.freehep.util.FreeHEPLookup;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.openide.util.Lookup;

public class CorbaTreeServantImpl
extends TreeServantPOA
implements AIDAListener {
    private ORB orb;
    private Tree tree;
    private TreeClient treeClient;
    private boolean duplex;
    private boolean keepRunning;
    private Vector sources;
    private CorbaServerEventQueue eventQueue;
    protected boolean useValidation;
    private Map converters;

    public CorbaTreeServantImpl(ORB orb, Tree tree) {
        System.out.println("Starting TreeServant, DuplexMode = false");
        this.orb = orb;
        this.tree = tree;
        this.treeClient = null;
        this.duplex = false;
        this.init();
        this.eventQueue = new CorbaServerEventQueue();
    }

    public CorbaTreeServantImpl(ORB orb, Tree tree, TreeClient treeClient) {
        System.out.println("Starting TreeServant, DuplexMode = " + (treeClient != null));
        this.orb = orb;
        this.tree = tree;
        this.treeClient = treeClient;
        if (treeClient == null) {
            throw new RuntimeException("Can not connect in Duplex mode with NULL Client Reference.");
        }
        this.duplex = true;
        this.init();
        this.eventQueue = new CorbaServerEventQueue(treeClient);
    }

    protected void init() {
        this.sources = new Vector();
        this.converters = new Hashtable();
        this.useValidation = true;
        this.keepRunning = this.duplex;
        if (this.tree instanceof IsObservable) {
            this.tree.addListener(this);
            this.sources.add(this.tree);
            this.tree.setValid(this);
        }
        if (this.tree instanceof Tree) {
            this.tree.setFolderIsWatched("/", true);
        }
    }

    public void setUseValidation(boolean state) {
        this.useValidation = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CorbaTreeServantImpl corbaTreeServantImpl = this;
        synchronized (corbaTreeServantImpl) {
            System.out.print("\n\tClosing BasicTreeServant ... ");
            this.keepRunning = false;
            this.eventQueue.close();
            for (int i = 0; i < this.sources.size(); ++i) {
                IsObservable o = (IsObservable)this.sources.get(i);
                if (o == null) continue;
                o.removeListener(this);
            }
            this.sources.clear();
            this.sources = null;
            this.converters.clear();
            this.converters = null;
            this.tree = null;
            this.treeClient = null;
            this.eventQueue = null;
            System.out.print(" Done\n");
        }
    }

    public void stateChanged(EventObject ev) {
        EventID eid = null;
        EventFlags eflags = EventFlags.OBJECT_MASK;
        String pathString = "";
        String nodeType = "null";
        if (ev instanceof TreeEvent) {
            String[] path;
            TreeEvent tev = (TreeEvent)ev;
            if (tev.getType() != null) {
                nodeType = tev.getType().getName();
            }
            if (tev.getFlags() == 1) {
                eflags = EventFlags.FOLDER_MASK;
                nodeType = "dir";
            }
            if ((path = tev.getPath()) != null) {
                for (int i = 0; i < path.length; ++i) {
                    pathString = pathString + "/" + path[i];
                }
            }
            if (tev.getID() == 1) {
                eid = EventID.NODE_ADDED;
                if (!nodeType.equalsIgnoreCase("dir")) {
                    IManagedObject mo = this.tree.find(pathString);
                    if (mo instanceof ManagedObject) {
                        nodeType = ((ManagedObject)mo).getAIDAType();
                    }
                    if (mo instanceof IsObservable) {
                        if (!this.sources.contains(mo)) {
                            ((IsObservable)mo).addListener(this);
                            this.sources.add(mo);
                        }
                        if (!this.useValidation) {
                            ((IsObservable)mo).setValid(this);
                        }
                    }
                }
            } else if (tev.getID() == 2) {
                eid = EventID.NODE_DELETED;
            }
            if (eid == null) {
                return;
            }
            if (!this.useValidation && this.tree instanceof IsObservable) {
                this.tree.setValid(this);
            }
        } else if (ev instanceof HistogramEvent) {
            IBaseHistogram hist = (IBaseHistogram)ev.getSource();
            pathString = this.tree.findPath((IManagedObject)hist);
            eid = EventID.NODE_UPDATED;
            eflags = EventFlags.OBJECT_MASK;
            nodeType = hist instanceof ManagedObject ? ((ManagedObject)hist).getAIDAType() : hist.getClass().getName();
            if (!this.useValidation && hist instanceof IsObservable) {
                ((IsObservable)hist).setValid(this);
            }
        } else if (ev instanceof DataPointSetEvent) {
            IDataPointSet mo = (IDataPointSet)ev.getSource();
            pathString = this.tree.findPath((IManagedObject)mo);
            eid = EventID.NODE_UPDATED;
            eflags = EventFlags.OBJECT_MASK;
            nodeType = mo instanceof ManagedObject ? ((ManagedObject)mo).getAIDAType() : mo.getClass().getName();
            if (!this.useValidation && mo instanceof IsObservable) {
                ((IsObservable)mo).setValid(this);
            }
        } else {
            System.out.println("CorbaTreeServantImpl.stateChanged Unknown Event: " + ev);
            return;
        }
        System.out.println("CorbaTreeServantImpl: process Event: id = " + eid.value() + ",  path = " + pathString + ",  type = " + nodeType + ",  flags = " + eflags.value());
        this.eventQueue.schedule(new EventStruct(eid, pathString, nodeType, eflags));
    }

    public String[] listObjectNames(String path) {
        this.tree.setFolderIsWatched(path, true);
        return this.tree.listObjectNames(path);
    }

    public String[] listObjectTypes(String path) {
        this.tree.setFolderIsWatched(path, true);
        return this.tree.listObjectTypes(path);
    }

    public String findRetString(String path) {
        IManagedObject mo = this.tree.find(path);
        String str = mo.toString();
        return str;
    }

    public void setValid(String path) {
        System.out.println("CorbaTreeServantImpl.setValid: path=" + path);
        if (path == null || path.equals("") || path.equals("/")) {
            if (!this.useValidation) {
                this.tree.setValid(this);
            }
        } else {
            IManagedObject mo = this.tree.find(path);
            System.out.println("CorbaTreeServantImpl.setValid: Find Object=" + (mo == null ? "null" : mo.name()));
            if (!this.sources.contains(mo) && mo instanceof IsObservable) {
                ((IsObservable)mo).addListener(this);
                this.sources.add(mo);
            }
            if (mo instanceof IsObservable) {
                ((IsObservable)mo).setValid(this);
                System.out.println("CorbaTreeServantImpl.setValid: Just DID Actual Set Valid!");
            }
        }
    }

    public void setValid(String[] path) {
        if (path != null && path.length != 0) {
            for (int i = 0; i < path.length; ++i) {
                System.out.println("CorbaTreeServantImpl.setValid: path[" + i + "] = " + path[i]);
                this.setValid(path[i]);
            }
        }
    }

    public EventStruct[] updates() {
        EventStruct[] events = this.eventQueue.getEvents();
        return events;
    }

    public Any find(String path) {
        System.out.println("TreeServantImpl.find for  " + path);
        IManagedObject mo = this.tree.find(path);
        System.out.println("\tTreeServantImpl.find MO  " + mo);
        if (mo instanceof IsObservable && !this.sources.contains((IsObservable)mo)) {
            ((IsObservable)mo).addListener(this);
            this.sources.add((IsObservable)mo);
        }
        String aidaType = "";
        aidaType = mo instanceof ManagedObject ? ((ManagedObject)mo).getAIDAType() : mo.getClass().getName();
        CorbaConverter converter = null;
        if (this.converters.containsKey(aidaType)) {
            converter = (CorbaConverter)this.converters.get(aidaType);
        } else {
            Lookup.Template template = new Lookup.Template(CorbaConverter.class, aidaType, null);
            Lookup.Item item = FreeHEPLookup.instance().lookupItem(template);
            if (item == null) {
                throw new IllegalArgumentException("No Converter for AIDA Type: " + aidaType);
            }
            converter = (CorbaConverter)item.getInstance();
            this.converters.put(aidaType, converter);
        }
        Any a = (Any)converter.extractData(mo);
        try {
            System.out.println("Check Type:");
            TypeCode type = a.type();
            System.out.println("\tGOT TypeCode:  name=" + type.name() + ", ID=" + type.id() + ", kind=" + type.kind() + ", kind.value()=" + type.kind().value());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return a;
    }
}

