/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.client;

import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.remote.RemoteClient;
import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.interfaces.AidaTreeServer;
import hep.aida.ref.remote.rmi.RmiRemoteUtils;
import hep.aida.ref.remote.rmi.client.RmiRemoteServer;
import hep.aida.ref.remote.rmi.interfaces.RmiServer;
import java.rmi.Naming;
import java.util.Iterator;
import java.util.Map;

public class RmiRemoteClient
extends RemoteClient {
    private Map options;

    public RmiRemoteClient(IDevMutableStore store, Map options) {
        super(store);
        this.options = options;
    }

    public RmiRemoteClient(IDevMutableStore store, boolean duplex, Map options) {
        super(store, duplex);
        this.options = options;
    }

    protected void init() {
        super.init();
        this.clientID = "RmiRemoteClient/" + RmiRemoteUtils.getCurrentDateString();
    }

    protected AidaTreeServer getServer() {
        RmiRemoteServer treeServer = null;
        try {
            RmiServer server = null;
            String rmiServerName = null;
            Iterator it = this.options.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)this.options.get(key);
                this.remoteLogger.fine("Key = " + key + " \tValue = " + value);
                if (!key.equalsIgnoreCase("RmiServerName")) continue;
                rmiServerName = value;
            }
            server = (RmiServer)Naming.lookup(rmiServerName);
            treeServer = new RmiRemoteServer(server);
        }
        catch (Exception e) {
            throw new RemoteConnectionException(e.getMessage(), e);
        }
        return treeServer;
    }

    public boolean disconnect() {
        boolean ok = super.disconnect();
        this.options = null;
        return ok;
    }
}

