/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tree;

import hep.aida.ref.AidaUtils;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;

class Path {
    private static final char separatorChar = '/';
    private static final String separatorString = new String(new char[]{'/'});
    private Stack stack;

    Path() {
        this.stack = new Stack();
    }

    Path(Path start, String path) {
        int l;
        int pos = 0;
        if (path == null) {
            path = "";
        }
        if ((l = path.length()) > 0 && path.charAt(0) == '/') {
            this.stack = new Stack();
            ++pos;
        } else {
            this.stack = (Stack)start.stack.clone();
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            while (token.endsWith("\\")) {
                token = token.substring(0, token.length() - 1) + "/";
                if (!tokenizer.hasMoreTokens()) continue;
                token = token + tokenizer.nextToken();
            }
            if (token.equals(".") || token.equals("")) continue;
            if (token.equals("..")) {
                if (this.stack.isEmpty()) {
                    throw new IllegalArgumentException("Hit rock bottom");
                }
                this.stack.pop();
                continue;
            }
            this.stack.push(token);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append('/');
        if (!this.stack.isEmpty()) {
            int i = 0;
            while (true) {
                String token = AidaUtils.modifyName((String)this.stack.get(i));
                b.append(token);
                if (++i == this.stack.size()) break;
                b.append('/');
            }
        }
        return b.toString();
    }

    public String toString(int start, int stop) {
        if (start < 0 || start > stop || stop > this.size()) {
            throw new IllegalArgumentException("PATH: Wrong START or STOP points:  " + start + "   " + stop);
        }
        StringBuffer b = new StringBuffer();
        b.append('/');
        if (!this.stack.isEmpty()) {
            int i = start;
            while (i < this.size()) {
                String token = AidaUtils.modifyName((String)this.stack.get(i));
                b.append(token);
                if (++i >= stop) break;
                b.append('/');
            }
        }
        return b.toString();
    }

    Path parent() {
        return new Path(this, "..");
    }

    String getName() {
        return this.stack.isEmpty() ? separatorString : AidaUtils.modifyName((String)this.stack.peek());
    }

    Iterator iterator() {
        return this.stack.iterator();
    }

    int size() {
        return this.stack.size();
    }

    String[] toArray() {
        Object[] result = new String[this.stack.size()];
        this.stack.copyInto(result);
        return result;
    }

    String[] toArray(int depth) {
        String[] result = new String[depth];
        for (int i = 0; i < depth; ++i) {
            result[i] = (String)this.stack.get(i);
        }
        return result;
    }

    String[] toArray(String item) {
        Object[] result = new String[this.stack.size() + 1];
        this.stack.copyInto(result);
        result[this.stack.size()] = item;
        return result;
    }
}

