/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tree;

import hep.aida.IAnalysisFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ref.tree.Tree;
import java.io.IOException;

public class TreeFactory
implements ITreeFactory {
    private IAnalysisFactory analysisFactory;

    public TreeFactory(IAnalysisFactory analysisFactory) {
        this.analysisFactory = analysisFactory;
    }

    public ITree create() {
        return new Tree(this.analysisFactory);
    }

    public ITree create(String storeName) throws IllegalArgumentException, IOException {
        return this.create(storeName, null);
    }

    public ITree create(String storeName, String storeType) throws IllegalArgumentException, IOException {
        return this.createTree(storeName, storeType, false, false, null, false);
    }

    public ITree create(String storeName, String storeType, boolean readOnly) throws IllegalArgumentException, IOException {
        return this.create(storeName, storeType, readOnly, false);
    }

    public ITree create(String storeName, String storeType, boolean readOnly, boolean createNew) throws IllegalArgumentException, IOException {
        return this.create(storeName, storeType, readOnly, createNew, null);
    }

    public ITree create(String storeName, String storeType, boolean readOnly, boolean createNew, String options) throws IllegalArgumentException, IOException {
        return this.createTree(storeName, storeType, readOnly, createNew, options, true);
    }

    protected ITree createTree(String storeName, String storeType, boolean readOnly, boolean createNew, String options, boolean readOnlyUserDefined) throws IllegalArgumentException, IOException {
        Tree tree = new Tree(this.analysisFactory);
        tree.init(storeName, readOnly, createNew, storeType, options, readOnlyUserDefined);
        return tree;
    }
}

