/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tree;

import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteTree;

public class TreeUpdater
implements Runnable {
    private ITree tree;
    private String updatePath;
    private long updateInterval;
    private boolean keepUpdating;
    private Thread thread;

    public TreeUpdater(ITree tree) {
        this(tree, 30000L);
    }

    public TreeUpdater(ITree tree, long updateInterval) {
        this(tree, updateInterval, "/");
    }

    public TreeUpdater(ITree tree, long updateInterval, String updatePath) {
        this.tree = tree;
        this.updateInterval = updateInterval;
        this.updatePath = updatePath;
        this.keepUpdating = false;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdatePath(String updatePath) {
        this.updatePath = updatePath;
    }

    public String getUpdatePath() {
        return this.updatePath;
    }

    public boolean isUpdating() {
        return this.keepUpdating;
    }

    public void startUpdating() {
        if (this.keepUpdating) {
            System.out.println("TreeUpdater.startUpdaiting:  already is updating, no action taken");
            return;
        }
        this.keepUpdating = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stopUpdating(boolean urgent) {
        if (!this.keepUpdating || this.thread == null) {
            System.out.println("TreeUpdater.stopUpdaiting:  not updating, no action taken");
            return;
        }
        if (!urgent) {
            this.keepUpdating = false;
        } else {
            try {
                this.thread.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int updateTree(String pathString) {
        int nObjects = 0;
        String[] names = this.tree.listObjectNames(pathString, true);
        String[] types = this.tree.listObjectTypes(pathString, true);
        if (names == null) {
            return 0;
        }
        for (int i = 0; i < names.length; ++i) {
            if (types[i].equalsIgnoreCase("dir")) continue;
            try {
                IManagedObject obj = this.tree.find(names[i]);
                if (obj instanceof RemoteManagedObject) {
                    RemoteManagedObject rmo = (RemoteManagedObject)obj;
                    if (!rmo.isDataValid()) continue;
                    rmo.setDataValid(false);
                    ++nObjects;
                    continue;
                }
                if (!(obj instanceof ManagedObject)) continue;
                ManagedObject mo = (ManagedObject)obj;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nObjects;
    }

    public void run() {
        int nObjects = 0;
        while (this.keepUpdating) {
            try {
                long t1 = System.currentTimeMillis();
                if (this.tree != null) {
                    nObjects = this.tree instanceof RemoteTree ? ((RemoteTree)this.tree).doUpdate(this.updatePath) : this.updateTree(this.updatePath);
                }
                long t2 = System.currentTimeMillis();
                long time = t2 - t1;
                System.out.println("\tTreeUpdater.run: Finished Tree Update. Updated: " + nObjects + " objects, Time=" + time + " milliseconds");
                Thread.sleep(this.updateInterval);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

