/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.IManagedObject;
import hep.aida.ITuple;
import hep.tuple.interfaces.FTuple;
import hep.tuple.interfaces.FTupleColumn;
import hep.tuple.interfaces.FTupleCursor;
import java.util.Date;
import org.freehep.util.Value;

public class FTupleAdapter
implements FTuple {
    private ITuple tuple;
    private FTupleColumn[] columns;
    private FTuple[] tuples;
    private FTupleCursor cursor;
    private boolean supportsRandomAccess = false;
    static /* synthetic */ Class class$hep$aida$ITuple;
    static /* synthetic */ Class class$hep$tuple$interfaces$FTuple;

    public FTupleAdapter(ITuple tuple) {
        this.setTuple(tuple);
        this.columns = new FTupleColumn[tuple.columns()];
        this.tuples = new FTuple[tuple.columns()];
        this.cursor = new FTupleCursorAdapter(tuple);
        try {
            if (tuple.rows() > 0) {
                this.cursor.setRow(0);
            }
            this.supportsRandomAccess = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.cursor.start();
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = new FTupleColumnAdapter(tuple, i);
            if (tuple.columnType(i) != (class$hep$aida$ITuple == null ? FTupleAdapter.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) continue;
            this.tuples[i] = new FTupleAdapter(tuple.getTuple(i));
        }
    }

    public void close() {
    }

    public FTupleColumn column(int index) {
        return this.columns[index];
    }

    public FTupleColumn columnByName(String name) {
        return this.columns[this.tuple.findColumn(name)];
    }

    public int columnIndexByName(String name) {
        return this.tuple.findColumn(name);
    }

    public String columnName(int index) {
        return this.tuple.columnName(index);
    }

    public Class columnType(int index) {
        return this.columns[index].type();
    }

    public void columnValue(int column, FTupleCursor cursor, Value value) {
        Class type = this.columnType(column);
        if (type == Integer.TYPE) {
            value.set(this.tuple.getInt(column));
        } else if (type == Short.TYPE) {
            value.set(this.tuple.getShort(column));
        } else if (type == Long.TYPE) {
            value.set(this.tuple.getLong(column));
        } else if (type == Float.TYPE) {
            value.set(this.tuple.getFloat(column));
        } else if (type == Double.TYPE) {
            value.set(this.tuple.getDouble(column));
        } else if (type == Boolean.TYPE) {
            value.set(this.tuple.getBoolean(column));
        } else if (type == Byte.TYPE) {
            value.set(this.tuple.getByte(column));
        } else if (type == Character.TYPE) {
            value.set(this.tuple.getChar(column));
        } else if (type == String.class) {
            value.set(this.tuple.getString(column));
        } else if (type == Date.class) {
            value.set((Date)this.tuple.getObject(column));
        } else {
            value.set(this.tuple.getObject(column));
        }
    }

    public int columns() {
        return this.tuple.columns();
    }

    public FTupleCursor cursor() throws IllegalStateException {
        return this.cursor;
    }

    public boolean isInMemory() {
        return false;
    }

    public String name() {
        if (this.tuple instanceof IManagedObject) {
            return ((IManagedObject)this.tuple).name();
        }
        return "title";
    }

    public int rows() {
        return this.tuple.rows();
    }

    public boolean supportsMultipleCursors() {
        return false;
    }

    public boolean supportsRandomAccess() {
        return this.supportsRandomAccess;
    }

    public String title() {
        return this.tuple.title();
    }

    public FTuple tuple(int index) {
        FTuple fTuple = this.tuples[index];
        ((FTupleAdapter)fTuple).setTuple(this.tuple.getTuple(index));
        return fTuple;
    }

    protected void setTuple(ITuple tuple) {
        this.tuple = tuple;
    }

    private class FTupleCursorAdapter
    implements FTupleCursor {
        private ITuple tuple;
        private int row = -1;

        FTupleCursorAdapter(ITuple tuple) {
            this.tuple = tuple;
        }

        public void close() {
        }

        public boolean next() {
            boolean advanced = this.tuple.next();
            if (advanced) {
                ++this.row;
            }
            return advanced;
        }

        public int row() {
            return this.row;
        }

        public void setRow(int n) {
            this.tuple.setRow(n);
            this.row = n;
        }

        public void skip(int rows) {
            this.tuple.skip(rows);
            this.row += rows;
        }

        public void start() {
            this.tuple.start();
            this.row = -1;
        }
    }

    private class FTupleColumnAdapter
    implements FTupleColumn {
        private ITuple tuple;
        private int col;

        FTupleColumnAdapter(ITuple tuple, int col) {
            this.tuple = tuple;
            this.col = col;
        }

        public boolean hasDefaultValue() {
            return false;
        }

        public void defaultValue(Value value) {
        }

        public void maxValue(Value value) {
            value.set(this.tuple.columnMax(this.col));
        }

        public void meanValue(Value value) {
            value.set(this.tuple.columnMean(this.col));
        }

        public void minValue(Value value) {
            value.set(this.tuple.columnMin(this.col));
        }

        public String name() {
            return this.tuple.columnName(this.col);
        }

        public void rmsValue(Value value) {
            value.set(this.tuple.columnRms(this.col));
        }

        public Class type() {
            Class type = this.tuple.columnType(this.col);
            if (type == (class$hep$aida$ITuple == null ? (class$hep$aida$ITuple = FTupleAdapter.class$("hep.aida.ITuple")) : class$hep$aida$ITuple)) {
                return class$hep$tuple$interfaces$FTuple == null ? (class$hep$tuple$interfaces$FTuple = FTupleAdapter.class$("hep.tuple.interfaces.FTuple")) : class$hep$tuple$interfaces$FTuple;
            }
            return type;
        }
    }
}

