/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.xdr.XDRRandomAccessFile;
import java.io.IOException;

class BufferedRandomAccessFile
extends XDRRandomAccessFile {
    private byte[] buffer = new byte[8096];
    private int offset = 0;
    private int pos = 0;
    private int used = 0;

    BufferedRandomAccessFile(String name) throws IOException {
        super(name, "rw");
    }

    public long getFilePointer() throws IOException {
        return this.offset + this.pos;
    }

    public void close() throws IOException {
        this.flush();
        super.close();
        this.buffer = null;
    }

    public void flush() throws IOException {
        super.seek(this.offset);
        super.write(this.buffer, 0, this.used);
        this.offset += this.used;
        this.used = 0;
        this.pos = 0;
    }

    public int read() throws IOException {
        throw new IOException("Read not supported");
    }

    public int read(byte[] buf) throws IOException {
        throw new IOException("Read not supported");
    }

    public int read(byte[] buf, int start, int length) throws IOException {
        throw new IOException("Read not supported");
    }

    public void seek(long p1) throws IOException {
        if (p1 >= (long)this.offset && p1 <= (long)(this.offset + this.used)) {
            this.pos = (int)p1 - this.offset;
        } else {
            this.flush();
            this.offset = (int)p1;
        }
    }

    public void write(byte[] buf, int start, int len) throws IOException {
        if (this.buffer.length - this.pos <= len) {
            System.arraycopy(buf, start, this.buffer, this.pos, len);
            this.pos += len;
            if (this.pos > this.used) {
                this.used = this.pos;
            }
        } else {
            this.used = this.pos;
            this.flush();
            super.write(buf, start, len);
            this.offset += len;
        }
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(int b) throws IOException {
        if (this.pos == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.pos++] = (byte)b;
        if (this.pos > this.used) {
            this.used = this.pos;
        }
    }
}

