/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import hep.io.xdr.XDRSerializable;
import java.io.IOException;

public abstract class MCFIOBlock
implements XDRSerializable {
    protected String version;
    protected double fVersion;
    protected int id;
    protected int length;

    protected MCFIOBlock(int id) {
        this.id = id;
    }

    public void read(XDRDataInput xdr) throws IOException {
        int temp = xdr.readInt();
        if (this.id != temp) {
            throw new MCFIOException("Block error, expected " + this.id + " got " + temp);
        }
        this.length = xdr.readInt();
        this.version = xdr.readString();
        try {
            this.fVersion = Double.parseDouble(this.version);
        }
        catch (NumberFormatException x) {
            throw new IOException("Invalid version " + this.version);
        }
    }

    public void write(XDRDataOutput xdr) throws IOException {
        xdr.writeInt(this.id);
        xdr.writeInt(this.getLength());
        xdr.writeString(this.version);
    }

    protected int getLength() {
        return this.length;
    }
}

