/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.EventTable;
import hep.io.mcfio.FileHeader;
import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOConstants;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class MCFIOReader
implements MCFIOConstants {
    private EventTable eventTable;
    private FileHeader fileHeader;
    private String file;
    private XDRDataInput xdr;
    private int currentEvent;

    public MCFIOReader(String file) throws IOException {
        this.file = file;
        this.init(new XDRInputStream(new FileInputStream(file)));
    }

    public MCFIOReader(InputStream input) throws IOException {
        this.init(new XDRInputStream(input));
    }

    public String getComment() {
        return this.fileHeader.getComment();
    }

    public String getDate() {
        return this.fileHeader.getDate();
    }

    public int getNumberOfEvents() {
        return this.fileHeader.getNumberOfEvents();
    }

    public int getNumberOfEventsExpected() {
        return this.fileHeader.getNumberOfEventsExpected();
    }

    public String getTitle() {
        return this.fileHeader.getTitle();
    }

    public void close() throws IOException {
        if (this.xdr instanceof RandomAccessFile) {
            ((RandomAccessFile)((Object)this.xdr)).close();
        } else {
            ((InputStream)((Object)this.xdr)).close();
        }
        this.fileHeader = null;
        this.eventTable = null;
    }

    public MCFIOEvent nextEvent() throws IOException {
        if (this.currentEvent >= this.eventTable.numevts()) {
            int next = this.eventTable.nextTable();
            if (next <= 0) {
                throw new EOFException();
            }
            this.skipTo(next);
            this.eventTable.read(this.xdr);
            this.currentEvent = 0;
        }
        return new EventHeader(this.currentEvent++);
    }

    public void rewind() throws IOException {
        if (this.file == null) {
            throw new IOException("Rewind not supported");
        }
        this.close();
        this.init(new XDRInputStream(new FileInputStream(this.file)));
    }

    protected MCFIOBlock createUserBlock(int id) throws IOException {
        throw new IOException("Unknown user block " + id);
    }

    private void init(XDRDataInput xdr) throws IOException {
        this.xdr = xdr;
        this.fileHeader = new FileHeader();
        this.fileHeader.read(xdr);
        this.eventTable = new EventTable();
        this.eventTable.read(xdr);
        this.currentEvent = 0;
    }

    private void skipTo(int target) throws IOException {
        if (this.xdr instanceof RandomAccessFile) {
            RandomAccessFile random = (RandomAccessFile)((Object)this.xdr);
            random.seek(target);
        } else {
            XDRInputStream input = (XDRInputStream)this.xdr;
            int pos = (int)input.getBytesRead();
            if (pos < target) {
                input.skipBytes(target - pos);
            } else if (pos > target) {
                throw new MCFIOException("Cannot skip backwards in sequential file: " + pos + " " + target);
            }
        }
    }

    private class EventHeader
    extends MCFIOBlock
    implements MCFIOEvent {
        private int[] blockIds;
        private int[] blockPtrs;
        private boolean haveRead;
        private int evtnum;
        private int nBlocks;
        private int pointer;
        private int runnum;
        private int storenum;
        private int trigMask;

        EventHeader(int index) throws IOException {
            super(4);
            this.haveRead = false;
            this.evtnum = MCFIOReader.this.eventTable.evtnum(index);
            this.runnum = MCFIOReader.this.eventTable.runnum(index);
            this.storenum = MCFIOReader.this.eventTable.storenum(index);
            this.trigMask = MCFIOReader.this.eventTable.trigMask(index);
            this.pointer = MCFIOReader.this.eventTable.ptrEvent(index);
        }

        public MCFIOBlock getBlock(int index) throws IOException {
            if (!this.haveRead) {
                this.readEvent();
            }
            MCFIOReader.this.skipTo(this.blockPtrs[index]);
            MCFIOBlock block = MCFIOReader.this.createUserBlock(this.blockIds[index]);
            block.read(MCFIOReader.this.xdr);
            return block;
        }

        public int getBlockID(int index) throws IOException {
            if (!this.haveRead) {
                this.readEvent();
            }
            return this.blockIds[index];
        }

        public int getEventNumber() {
            return this.evtnum;
        }

        public int getNBlocks() throws IOException {
            if (!this.haveRead) {
                this.readEvent();
            }
            return this.nBlocks;
        }

        public int getRunNumber() {
            return this.runnum;
        }

        public int getStoreNumber() {
            return this.storenum;
        }

        public int getTrigMask() {
            return this.trigMask;
        }

        public void read(XDRDataInput xdr) throws IOException {
            super.read(xdr);
            if (this.fVersion > 2.0) {
                throw new MCFIOException("Unsupported version " + this.version + " for EventHeader");
            }
            this.evtnum = xdr.readInt();
            this.storenum = xdr.readInt();
            this.runnum = xdr.readInt();
            this.trigMask = xdr.readInt();
            this.nBlocks = xdr.readInt();
            int dimBlocks = xdr.readInt();
            if (this.fVersion >= 2.0) {
                int nNTuples = xdr.readInt();
                int dimNTuples = xdr.readInt();
                if (nNTuples > 0) {
                    throw new IOException("NTuples not supported");
                }
            }
            this.blockIds = xdr.readIntArray(null);
            this.blockPtrs = xdr.readIntArray(null);
            for (int i = 0; i < this.nBlocks; ++i) {
                if (this.blockPtrs[i] != 0) continue;
                this.nBlocks = i;
            }
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("Run ");
            b.append(this.runnum);
            b.append(" store ");
            b.append(this.storenum);
            b.append(" event ");
            b.append(this.evtnum);
            b.append(" mask ");
            b.append(this.trigMask);
            if (this.haveRead) {
                b.append(" blocks [");
                int i = 0;
                while (true) {
                    b.append(this.blockIds[i]);
                    if (++i == this.nBlocks) break;
                    b.append(",");
                }
                b.append("]");
            }
            return b.toString();
        }

        private void readEvent() throws IOException {
            MCFIOReader.this.skipTo(this.pointer);
            this.read(MCFIOReader.this.xdr);
            this.haveRead = true;
        }
    }
}

