/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.core.BasicMember;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.ClassBuilder;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.NameMangler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.Type;

class ClonesBuilder
implements ClassBuilder,
Constants {
    private static NameMangler nameMangler = NameMangler.instance();
    private boolean optimize;

    ClonesBuilder() {
    }

    public String getStem() {
        return "hep.io.root.clones";
    }

    public JavaClass build(GenericRootClass klass) {
        this.optimize = (klass.getStreamerInfo().getBits() & 0x1000) == 0;
        System.out.println("bits=" + Integer.toHexString(klass.getStreamerInfo().getBits()) + " optimize=" + this.optimize);
        String className = this.getStem() + "." + klass.getClassName();
        ClassGen cg = new ClassGen(className, "hep/io/root/core/Clones", "<generated>", 33, null);
        ConstantPoolGen cp = cg.getConstantPool();
        InstructionList il = new InstructionList();
        InstructionFactory factory = new InstructionFactory(cg);
        cg.addEmptyConstructor(1);
        ArrayList<GenericRootClass> sup = new ArrayList<GenericRootClass>();
        RootClass[] superClasses = klass.getSuperClasses();
        this.iterativelyAdd(sup, superClasses);
        sup.add(klass);
        Iterator i = sup.iterator();
        while (i.hasNext()) {
            this.generateFields((RootClass)i.next(), cp, cg);
        }
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, new Type[]{new ObjectType("hep/io/root/core/RootInput"), Type.INT}, new String[]{"in", "nClones"}, "read", className, il, cp);
        mg.addException("java/io/IOException");
        Iterator i2 = sup.iterator();
        while (i2.hasNext()) {
            this.generateStreamer((RootClass)i2.next(), cp, il, factory, className);
        }
        il.append((Instruction)new RETURN());
        mg.setMaxStack();
        mg.setMaxLocals();
        cg.addMethod(mg.getMethod());
        il.dispose();
        return cg.getJavaClass();
    }

    private void generateFields(RootClass k, ConstantPoolGen cp, ClassGen cg) {
        if (k.getClassName().equals("TObject") && this.optimize) {
            return;
        }
        RootMember[] members = k.getMembers();
        for (int i = 0; i < members.length; ++i) {
            BasicMember member = (BasicMember)members[i];
            if (this.optimize && i + 1 < members.length && member.getArrayDim() == 0 && member.getJavaType().equals(((BasicMember)members[i + 1]).getJavaType())) continue;
            Type type = ((BasicMember)members[i]).getJavaType();
            type = new ArrayType(type, 1);
            FieldGen fg = new FieldGen(1, type, members[i].getName(), cp);
            cg.addField(fg.getField());
        }
    }

    private void generateStreamer(RootClass k, ConstantPoolGen cp, InstructionList il, InstructionFactory factory, String className) {
        if (k.getClassName().equals("TObject") && this.optimize) {
            return;
        }
        RootMember[] members = k.getMembers();
        int multiplier = 1;
        for (int i = 0; i < members.length; ++i) {
            BasicMember member = (BasicMember)members[i];
            if (this.optimize && i + 1 < members.length && member.getArrayDim() == 0 && member.getJavaType().equals(((BasicMember)members[i + 1]).getJavaType())) {
                ++multiplier;
                continue;
            }
            Type type = member.getJavaType();
            ArrayType arrayType = new ArrayType(type, 1);
            il.append((Instruction)InstructionConstants.ALOAD_0);
            il.append((Instruction)InstructionConstants.ALOAD_1);
            il.append((Instruction)InstructionConstants.ILOAD_2);
            if (multiplier > 1) {
                il.append((CompoundInstruction)new PUSH(cp, multiplier));
                il.append((Instruction)InstructionConstants.IMUL);
            }
            for (int j = 0; j < member.getArrayDim(); ++j) {
                il.append((CompoundInstruction)new PUSH(cp, member.getMaxIndex(j)));
            }
            il.append(factory.createNewArray(((BasicRootClass)member.getType()).getJavaType(), (short)(member.getArrayDim() + 1)));
            il.append((Instruction)InstructionConstants.DUP_X1);
            if (member.getArrayDim() == 0) {
                il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readFixedArray", (Type)Type.VOID, new Type[]{arrayType}, (short)185));
            } else {
                il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readMultiArray", (Type)Type.VOID, new Type[]{new ArrayType((Type)Type.OBJECT, 1)}, (short)185));
            }
            il.append((Instruction)factory.createPutField(className, member.getName(), (Type)arrayType));
            multiplier = 1;
        }
    }

    private void iterativelyAdd(List list, RootClass[] superClasses) {
        for (int i = 0; i < superClasses.length; ++i) {
            RootClass[] supsup = superClasses[i].getSuperClasses();
            this.iterativelyAdd(list, supsup);
            list.add(superClasses[i]);
        }
    }
}

