/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootFileReader;
import hep.io.root.RootObject;
import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootInput;
import hep.io.root.core.RootInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.zip.Inflater;

public class FastInputStream
implements RootInput {
    private static long elapsed;
    private static long invocations;
    private ByteBuffer buffer;
    private FastInputStream top;
    private HashMap map = new HashMap();
    private RootFileReader rfr;
    private byte[] in;
    private byte[] out;
    private int offset;
    private RandomAccessFile raf;

    public FastInputStream(RootFileReader rfr, RandomAccessFile raf) throws IOException {
        this.rfr = rfr;
        this.top = this;
        this.raf = raf;
        FileChannel channel = raf.getChannel();
        this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)raf.length());
        this.buffer.getInt();
    }

    private FastInputStream(ByteBuffer buffer, FastInputStream top) {
        this.buffer = buffer;
        this.top = top;
    }

    public RootClassFactory getFactory() {
        return this.top.rfr.getFactory();
    }

    public void setMap(int offset) {
        this.offset = offset - this.buffer.position();
    }

    public void setPosition(long pos) throws IOException {
        this.buffer.position((int)pos - this.offset);
    }

    public long getPosition() throws IOException {
        return this.buffer.position() + this.offset;
    }

    public int getRootVersion() {
        return this.top.rfr.getVersion();
    }

    public RootInput getTop() {
        return this.top;
    }

    public void checkLength(AbstractRootObject obj) throws IOException {
        obj.checkLength(this.buffer.position());
    }

    public void clearMap() {
        this.map.clear();
        this.offset = 0;
    }

    public void dump() {
        System.out.println("Decompressing took " + elapsed + "ms (" + invocations + ")");
        System.out.println("in size = " + this.in.length);
        System.out.println("out size = " + this.out.length);
    }

    public int readArray(short[] data) throws IOException {
        int n = this.buffer.getInt();
        this.buffer.asShortBuffer().get(data, 0, n);
        this.buffer.position(this.buffer.position() + n * 2);
        return n;
    }

    public int readArray(byte[] data) throws IOException {
        int n = this.buffer.getInt();
        this.buffer.get(data, 0, n);
        return n;
    }

    public int readArray(double[] data) throws IOException {
        int n = this.buffer.getInt();
        this.buffer.asDoubleBuffer().get(data, 0, n);
        this.buffer.position(this.buffer.position() + n * 8);
        return n;
    }

    public int readArray(float[] data) throws IOException {
        int n = this.buffer.getInt();
        this.buffer.asFloatBuffer().get(data, 0, n);
        this.buffer.position(this.buffer.position() + n * 4);
        return n;
    }

    public int readArray(int[] data) throws IOException {
        int n = this.buffer.getInt();
        this.buffer.asIntBuffer().get(data, 0, n);
        this.buffer.position(this.buffer.position() + n * 4);
        return n;
    }

    public boolean readBoolean() throws IOException {
        return this.buffer.get() != 0;
    }

    public byte readByte() throws IOException {
        return this.buffer.get();
    }

    public char readChar() throws IOException {
        return this.buffer.getChar();
    }

    public double readDouble() throws IOException {
        return this.buffer.getDouble();
    }

    public double readTwistedDouble() throws IOException {
        int i1 = this.buffer.getInt();
        int i2 = this.buffer.getInt();
        long val = (long)i1 + ((long)i2 << 32);
        return Double.longBitsToDouble(val);
    }

    public void readFixedArray(byte[] data) throws IOException {
        this.buffer.get(data);
    }

    public void readFixedArray(double[] data) throws IOException {
        this.buffer.asDoubleBuffer().get(data);
        this.buffer.position(this.buffer.position() + data.length * 8);
    }

    public void readFixedArray(int[] data) throws IOException {
        this.buffer.asIntBuffer().get(data);
        this.buffer.position(this.buffer.position() + data.length * 4);
    }

    public void readFixedArray(float[] data) throws IOException {
        this.buffer.asFloatBuffer().get(data);
        this.buffer.position(this.buffer.position() + data.length * 4);
    }

    public void readFixedArray(short[] data) throws IOException {
        this.buffer.asShortBuffer().get(data);
        this.buffer.position(this.buffer.position() + data.length * 2);
    }

    public float readFloat() throws IOException {
        return this.buffer.getFloat();
    }

    public void readFully(byte[] values) throws IOException {
        this.buffer.get(values);
    }

    public void readFully(byte[] values, int param, int param2) throws IOException {
        this.buffer.get(values, param, param2);
    }

    public int readInt() throws IOException {
        return this.buffer.getInt();
    }

    public String readLine() throws IOException {
        throw new IOException("Unimplemented method: readLine");
    }

    public long readLong() throws IOException {
        return this.buffer.getLong();
    }

    public void readMultiArray(Object[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            if (o instanceof double[]) {
                this.readFixedArray((double[])o);
                continue;
            }
            if (o instanceof float[]) {
                this.readFixedArray((float[])o);
                continue;
            }
            if (o instanceof short[]) {
                this.readFixedArray((short[])o);
                continue;
            }
            if (o instanceof byte[]) {
                this.readFixedArray((byte[])o);
                continue;
            }
            if (o instanceof int[]) {
                this.readFixedArray((int[])o);
                continue;
            }
            if (o instanceof Object[]) {
                this.readMultiArray((Object[])o);
                continue;
            }
            throw new IOException("Unknown multiarray element");
        }
    }

    public String readNullTerminatedString(int maxLength) throws IOException {
        int actualLength = maxLength - 1;
        byte[] data = new byte[maxLength];
        for (int i = 0; i < maxLength; ++i) {
            data[i] = this.buffer.get();
            if (data[i] != 0) continue;
            actualLength = i;
            break;
        }
        return new String(data, 0, actualLength);
    }

    public RootObject readObject(String type) throws IOException {
        return RootInputStream.readObject(this, type);
    }

    public RootObject readObjectRef() throws IOException {
        return RootInputStream.readObjectRef(this, this.map);
    }

    public short readShort() throws IOException {
        return this.buffer.getShort();
    }

    public String readString() throws IOException {
        byte l = this.buffer.get();
        byte[] data = new byte[l];
        this.buffer.get(data);
        return new String(data);
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public int readUnsignedByte() throws IOException {
        int result = this.buffer.get();
        if (result < 0) {
            result += 256;
        }
        return result;
    }

    public int readUnsignedShort() throws IOException {
        int result = this.buffer.getShort();
        if (result < 0) {
            result += 65536;
        }
        return result;
    }

    public int readVersion() throws IOException {
        return this.readVersion(null);
    }

    public int readVersion(AbstractRootObject obj) throws IOException {
        short version = this.buffer.getShort();
        if ((version & 0x4000) == 0) {
            return version;
        }
        int byteCount = ((version & 0x3FFF) << 16) + this.readUnsignedShort();
        if (obj != null) {
            obj.setExpectedLength(this.buffer.position(), byteCount);
        }
        return this.buffer.getShort();
    }

    public int skipBytes(int param) throws IOException {
        this.buffer.position(this.buffer.position() + param);
        return param;
    }

    public RootInput slice(int size) throws IOException {
        int oldLimit = this.buffer.limit();
        this.buffer.limit(this.buffer.position() + size);
        ByteBuffer slice = this.buffer.slice();
        this.buffer.position(this.buffer.limit());
        this.buffer.limit(oldLimit);
        return new FastInputStream(slice, this.top);
    }

    public RootInput slice(int inSize, int outSize) throws IOException {
        long start = System.currentTimeMillis();
        if (this.in == null) {
            this.in = new byte[32768];
        }
        if (this.out == null) {
            this.out = new byte[65536];
        }
        int nout = 0;
        int nin = 0;
        ByteBuffer slice = ByteBuffer.allocateDirect(outSize);
        Inflater inf = new Inflater(true);
        try {
            while (nout < outSize) {
                inf.reset();
                nin += 9;
                this.buffer.position(this.buffer.position() + 9);
                while (true) {
                    int rc;
                    if ((rc = inf.inflate(this.out)) == 0) {
                        if (inf.finished() || inf.needsDictionary()) break;
                        if (!inf.needsInput()) continue;
                        int l = Math.min(inSize - nin, this.in.length);
                        if (l == 0) break;
                        this.buffer.get(this.in, 0, l);
                        inf.setInput(this.in, 0, l);
                        nin += l;
                        continue;
                    }
                    slice.put(this.out, 0, rc);
                    nout += rc;
                }
                int back = inf.getRemaining();
                nin -= back;
                this.buffer.position(this.buffer.position() - back);
            }
            slice.rewind();
            long end = System.currentTimeMillis();
            elapsed += end - start;
            ++invocations;
            FastInputStream fastInputStream = new FastInputStream(slice, this.top);
            return fastInputStream;
        }
        catch (Exception x) {
            IOException io = new IOException("Error during decompression");
            io.initCause(x);
            throw io;
        }
        finally {
            inf.end();
        }
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

