/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.core.ClassBuilder;
import hep.io.root.core.Clone2Builder;
import hep.io.root.core.CloneBuilder;
import hep.io.root.core.ClonesBuilder;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.InterfaceBuilder;
import hep.io.root.core.Proxy2Builder;
import hep.io.root.core.ProxyBuilder;
import hep.io.root.test.JasminVisitor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;

public class RootClassLoader
extends ClassLoader {
    private static final boolean debugRoot = System.getProperty("debugRoot") != null;
    private Map classMap = new HashMap();
    private Map map = new HashMap();
    private RootFileReader rfr;

    RootClassLoader(RootFileReader rfr) {
        super(RootClassLoader.class.getClassLoader());
        this.rfr = rfr;
        this.register(new InterfaceBuilder());
        this.register(new ProxyBuilder());
        this.register(new Proxy2Builder());
        this.register(new ClonesBuilder());
        this.register(new CloneBuilder());
        this.register(new Clone2Builder());
    }

    public Class findClass(String name) throws ClassNotFoundException {
        try {
            int pos;
            String pkg;
            ClassBuilder builder;
            if (debugRoot) {
                System.out.println("RootClassLoader: loading " + name);
            }
            if ((builder = (ClassBuilder)this.map.get(pkg = name.substring(0, pos = name.lastIndexOf(46)))) == null) {
                throw new ClassNotFoundException(name);
            }
            String className = name.substring(pos + 1);
            GenericRootClass gc = (GenericRootClass)this.rfr.getFactory().create(className);
            JavaClass jc = builder.build(gc);
            if (debugRoot) {
                try {
                    FileOutputStream out = new FileOutputStream(name + ".j");
                    new JasminVisitor(jc, (OutputStream)out).disassemble();
                    out.close();
                }
                catch (IOException x) {
                    // empty catch block
                }
            }
            byte[] data = jc.getBytes();
            Class<?> result = this.defineClass(name, data, 0, data.length);
            this.classMap.put(result, gc);
            return result;
        }
        catch (RootClassNotFound x) {
            throw new ClassNotFoundException(name);
        }
    }

    public Class loadSpecial(ClassBuilder builder, String name, GenericRootClass rc) {
        if (debugRoot) {
            System.out.println("RootClassLoader: loading special " + name);
        }
        JavaClass jc = builder.build(rc);
        if (debugRoot) {
            try {
                FileOutputStream out = new FileOutputStream(name + ".j");
                new JasminVisitor(jc, (OutputStream)out).disassemble();
                out.close();
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        byte[] data = jc.getBytes();
        Class<?> result = this.defineClass(name, data, 0, data.length);
        this.classMap.put(result, rc);
        return result;
    }

    GenericRootClass getRootClass(Class klass) {
        return (GenericRootClass)this.classMap.get(klass);
    }

    private void register(ClassBuilder builder) {
        this.map.put(builder.getStem(), builder);
    }
}

