/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.RootClassNotFound;
import hep.io.root.RootMember;
import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.BasicMember;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.Clones2;
import hep.io.root.core.Clones2Builder;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.Hollow;
import hep.io.root.core.HollowBuilder;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TBranchElement;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TLeafElement;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public abstract class TLeafElementRep
extends AbstractRootObject
implements TLeafElement,
Constants {
    private BasicMember member;
    private Class hollowClass;
    private Clones2 clones;
    private Object lastValue;
    private RootInput rin;
    private TBranchElement branch;
    private int lastValueIndex;

    public void setBranch(TBranch branch) {
        this.branch = (TBranchElement)branch;
        this.lastValueIndex = -1;
    }

    public void setMember(RootMember member) {
        this.member = (BasicMember)member;
    }

    public RootInput setPosition(int index) throws IOException {
        return this.branch.setPosition(this, index);
    }

    public Object getValue(int index) throws IOException {
        try {
            boolean hollow;
            if (index == this.lastValueIndex) {
                return this.lastValue;
            }
            this.lastValueIndex = index;
            boolean bl = hollow = this.branch.getBranches().size() > 0;
            if (!hollow) {
                int fId = this.branch.getID();
                if (fId < 0) {
                    RootInput in = this.branch.setPosition(this, index);
                    String className = this.branch.getClassName();
                    Class<?> k = in.getFactory().getLoader().loadClass("hep.io.root.proxy2." + className);
                    AbstractRootObject o = (AbstractRootObject)k.newInstance();
                    in.readShort();
                    o.read(in);
                    this.lastValue = o;
                    return this.lastValue;
                }
                RootInput in = this.branch.setPosition(this, index);
                int streamerType = this.branch.getStreamerType();
                this.lastValue = new Integer(in.readInt());
                return this.lastValue;
            }
            String clonesName = this.branch.getClonesName();
            if (clonesName.length() > 0) {
                RootInput in = this.branch.setPosition((TLeaf)this.branch.getLeaves().get(0), index);
                if (this.hollowClass == null) {
                    Clones2Builder builder = new Clones2Builder(this.branch);
                    String name = "hep.io.root.clones2." + this.branch.getClonesName();
                    RootClassFactory factory = in.getFactory();
                    GenericRootClass gc = (GenericRootClass)factory.create(this.branch.getClonesName());
                    this.hollowClass = factory.getLoader().loadSpecial(builder, name, gc);
                    builder.populateStatics(this.hollowClass, factory);
                    this.clones = (Clones2)this.hollowClass.newInstance();
                }
                int size = in.readInt();
                this.clones.setData(size, index);
                return this.clones;
            }
            String className = ((TBranchElement)this.branch.getBranches().get(0)).getClassName();
            BasicRootClass rc = this.rin.getFactory().create(className);
            int fType = this.branch.getType();
            if (this.hollowClass == null) {
                HollowBuilder builder = new HollowBuilder(this.branch);
                String name = "hep.io.root.hollow." + this.branch.getClassName();
                RootClassFactory factory = this.rin.getFactory();
                GenericRootClass gc = (GenericRootClass)factory.create(this.branch.getClassName());
                this.hollowClass = factory.getLoader().loadSpecial(builder, name, gc);
                builder.populateStatics(this.hollowClass, factory);
            }
            Hollow h = (Hollow)this.hollowClass.newInstance();
            h.setHollowIndex(index);
            this.lastValue = h;
            return this.lastValue;
        }
        catch (IOException x) {
            x.printStackTrace();
            System.exit(0);
            this.lastValueIndex = -1;
            throw x;
        }
        catch (RootClassNotFound x) {
            this.lastValueIndex = -1;
            throw new IOException("RootClassNotFound " + x.getClassName());
        }
        catch (Throwable x) {
            x.printStackTrace();
            this.lastValueIndex = -1;
            throw new IOException("RootClassNotFound " + x);
        }
    }

    public Object getWrappedValue(int index) throws IOException {
        return this.getValue(index);
    }

    public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
        String leafClassName = this.getClass().getName();
        int fId = this.branch.getID();
        int nBranches = this.branch.getBranches().size();
        if (fId >= 0) {
            if (nBranches == 0) {
                il.append((Instruction)factory.createInvoke(leafClassName, "setPosition", (Type)new ObjectType("hep.io.root.core.RootInput"), new Type[]{Type.INT}, (short)182));
                this.member.generateReadCode(il, factory, cp, className);
            } else {
                il.append((Instruction)factory.createInvoke(leafClassName, "getValue", (Type)Type.OBJECT, new Type[]{Type.INT}, (short)182));
            }
        } else {
            System.out.println("***************************NEVER CALLED???????***************************");
            il.append((Instruction)factory.createInvoke(leafClassName, "getValue", (Type)Type.OBJECT, new Type[]{Type.INT}, (short)182));
        }
    }

    public void read(RootInput in) throws IOException {
        super.read(in);
        this.rin = in;
    }
}

