/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TLeafI;
import java.io.IOException;
import java.lang.reflect.Array;

public abstract class TLeafRep
extends AbstractRootObject
implements TLeaf {
    private int[] maxIndex;
    private int arrayDim;

    public int getArrayDim() {
        return this.arrayDim;
    }

    public int[] getMaxIndex() {
        return this.maxIndex;
    }

    public void read(RootInput in) throws IOException {
        super.read(in);
        this.arrayDim = 0;
        this.maxIndex = new int[5];
        String title = this.getTitle() + this.getName();
        int p1 = 0;
        int p2 = 0;
        while (title != null) {
            p1 = title.indexOf(91, p2);
            p2 = title.indexOf(93, p1);
            if (p1 < 0 || p2 <= p1) break;
            try {
                this.maxIndex[this.arrayDim] = Integer.parseInt(title.substring(p1 + 1, p2));
            }
            catch (NumberFormatException x) {
                this.maxIndex[this.arrayDim] = -1;
            }
            ++this.arrayDim;
        }
    }

    Object[] readMultiArray(RootInput in, Class type, int index) throws IOException {
        TLeafI count = (TLeafI)this.getLeafCount();
        int[] maxIndex = this.getMaxIndex();
        int[] dims = new int[this.arrayDim];
        for (int i = 0; i < this.arrayDim; ++i) {
            dims[i] = maxIndex[i] >= 0 ? maxIndex[i] : count.getValue(index);
        }
        Object[] array = (Object[])Array.newInstance(type, dims);
        in.readMultiArray(array);
        return array;
    }
}

