/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.RootObject;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class RootObjectTreeModel
extends DefaultTreeModel {
    public RootObjectTreeModel(Object top, String name) {
        super(RootObjectTreeNode.getNodeForValue(null, top, name, 0));
    }

    protected RootObjectTreeModel(TreeNode node) {
        super(node);
    }

    protected static int getIndex(TreeNode child) {
        return ((RootObjectTreeNode)child).index;
    }

    protected static TreeNode getNodeForChild(TreeNode parent, Object child, String name, int index) {
        return RootObjectTreeNode.getNodeForValue(parent, child, name, index);
    }

    static class RootSubObject
    extends RootObjectTreeNode {
        private RootClass klass;
        private RootObject obj;

        RootSubObject(TreeNode parent, RootObject obj, RootClass klass, int index) {
            super(parent, index);
            this.obj = obj;
            this.klass = klass;
        }

        public TreeNode getChildAt(int index) {
            RootClass[] superClasses = this.klass.getSuperClasses();
            if (index < superClasses.length) {
                return new RootSubObject(this, this.obj, superClasses[index], index);
            }
            RootMember member = this.klass.getMembers()[index - superClasses.length];
            Object value = member.getValue(this.obj);
            RootObjectTreeNode node = RootSubObject.getNodeForValue(this, value, member.getName(), index);
            node.setToolTip(member.getComment());
            return node;
        }

        public int getChildCount() {
            int n = this.klass.getSuperClasses().length;
            return n += this.klass.getMembers().length;
        }

        String description() {
            return "Class " + this.klass.getClassName();
        }
    }

    static class RootSimpleValue
    extends RootObjectTreeNode {
        private Object value;
        private String name;

        RootSimpleValue(TreeNode parent, Object value, String name, int index) {
            super(parent, index);
            this.value = value;
            this.name = name;
        }

        public boolean isLeaf() {
            return true;
        }

        String description() {
            return this.name + " = " + this.value;
        }
    }

    static class RootObjectNode
    extends RootSubObject {
        private String name;

        RootObjectNode(TreeNode parent, RootObject obj, String name, int index) {
            super(parent, obj, obj.getRootClass(), index);
            this.name = name;
        }

        String description() {
            return this.name + " (" + super.description() + ")";
        }
    }

    static class RootListNode
    extends RootObjectTreeNode {
        private List list;
        private String name;

        RootListNode(TreeNode parent, List list, String name, int index) {
            super(parent, index);
            this.list = list;
            this.name = name;
        }

        public TreeNode getChildAt(int index) {
            return RootListNode.getNodeForValue(this, this.list.get(index), "[" + index + "]", index);
        }

        public int getChildCount() {
            return this.list.size();
        }

        String description() {
            return this.name + " (List)";
        }
    }

    static class RootArrayNode
    extends RootObjectTreeNode {
        private Object array;
        private String name;

        RootArrayNode(TreeNode parent, Object array, String name, int index) {
            super(parent, index);
            this.array = array;
            this.name = name;
        }

        public TreeNode getChildAt(int index) {
            return RootArrayNode.getNodeForValue(this, Array.get(this.array, index), "[" + index + "]", index);
        }

        public int getChildCount() {
            return Array.getLength(this.array);
        }

        String description() {
            return this.name + " (Array)";
        }
    }

    static abstract class RootObjectTreeNode
    implements TreeNode {
        private String tooltip;
        private TreeNode parent;
        private int index;

        RootObjectTreeNode(TreeNode parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int p1) {
            throw new InternalError("getChildAt() called");
        }

        public int getChildCount() {
            return 0;
        }

        public int getIndex(TreeNode child) {
            return ((RootObjectTreeNode)child).index;
        }

        public boolean isLeaf() {
            return false;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public Enumeration children() {
            return new Enumeration(this){
                private int n;
                private int i;
                private final /* synthetic */ RootObjectTreeNode this$0;
                {
                    this.this$0 = this$0;
                    this.n = this.this$0.getChildCount();
                    this.i = 0;
                }

                public boolean hasMoreElements() {
                    return this.i < this.n;
                }

                public Object nextElement() {
                    return this.this$0.getChildAt(this.i++);
                }
            };
        }

        public boolean equals(Object obj) {
            if (obj instanceof RootObjectTreeNode) {
                RootObjectTreeNode other = (RootObjectTreeNode)obj;
                if (this.index != other.index) {
                    return false;
                }
                if (this.parent == null) {
                    return other.parent == null;
                }
                return this.parent.equals(other.parent);
            }
            return false;
        }

        public int hashCode() {
            return this.index + (this.parent == null ? 0 : this.parent.hashCode());
        }

        public String toString() {
            return this.description();
        }

        static RootObjectTreeNode getNodeForValue(TreeNode parent, Object value, String name, int index) {
            if (value == null) {
                return new RootSimpleValue(parent, "null", name, index);
            }
            if (value instanceof List) {
                return new RootListNode(parent, (List)value, name, index);
            }
            if (value.getClass().isArray()) {
                return new RootArrayNode(parent, value, name, index);
            }
            if (value instanceof RootObject) {
                return new RootObjectNode(parent, (RootObject)value, name, index);
            }
            return new RootSimpleValue(parent, value, name, index);
        }

        void setToolTip(String value) {
            this.tooltip = value;
        }

        abstract String description();

        String toolTip() {
            return this.tooltip;
        }
    }
}

