/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.Cursor;
import hep.tuple.TupleColumn;
import hep.tuple.TupleColumnFolder;
import hep.tuple.TupleColumnInt;
import hep.tuple.interfaces.FTuple;
import hep.tuple.interfaces.FTupleColumn;
import hep.tuple.interfaces.FTupleCursor;
import hep.tuple.interfaces.FillableTuple;
import hep.tuple.interfaces.FillableTupleColumn;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.freehep.util.Value;

public class Tuple
implements FillableTuple {
    private String title;
    private String name;
    private String options = "";
    protected static final int COLUMN_ROWS = 1000;
    protected int columnLength;
    protected int columnMaxLength;
    protected int startRow = 0;
    protected int endRow = -1;
    protected int filledRows = 0;
    protected Map optionMap;
    protected ArrayList tupleColumns = new ArrayList();
    protected ArrayList folderList = new ArrayList();
    protected Hashtable columnCounters = new Hashtable();
    protected Value tupleValue = new Value();

    protected Tuple(String name, String title) {
        this(name, title, "");
    }

    protected Tuple(String name, String title, String options) {
        this.name = name;
        this.title = title;
        this.options = options;
    }

    public void addColumn(FillableTupleColumn column) {
        this.tupleColumns.add(column);
    }

    public void removeColumn(FillableTupleColumn column) {
        this.tupleColumns.remove(column);
    }

    public int columns() {
        return this.tupleColumns.size();
    }

    public FTupleColumn column(int column) {
        return (FTupleColumn)this.tupleColumns.get(column);
    }

    public FTupleColumn columnByName(String name) {
        return this.column(this.columnIndexByName(name));
    }

    public int columnIndexByName(String name) {
        for (int i = 0; i < this.columns(); ++i) {
            if (!this.columnName(i).equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("Column " + name + " does not exist\n");
    }

    public String columnName(int column) {
        return this.column(column).name();
    }

    public Class columnType(int column) {
        return this.column(column).type();
    }

    public void columnMinValue(int column, Value value) {
        this.column(column).minValue(value);
    }

    public void columnMaxValue(int column, Value value) {
        this.column(column).maxValue(value);
    }

    public void columnMeanValue(int column, Value value) {
        this.column(column).meanValue(value);
    }

    public void columnRmsValue(int column, Value value) {
        this.column(column).rmsValue(value);
    }

    public void addRow() {
        for (int i = 0; i < this.columns(); ++i) {
            ((TupleColumn)this.column(i)).addRow();
        }
        Enumeration keys = this.columnCounters.keys();
        while (keys.hasMoreElements()) {
            String folderName = (String)keys.nextElement();
            Tuple folder = this.getFolder(this.columnIndexByName(folderName), this.filledRows);
            TupleColumn tc = (TupleColumn)this.columnCounters.get(folderName);
            tc.fill(this.tupleValue.set(folder.startRow() + folder.rows()));
            tc.addRow();
        }
        ++this.filledRows;
    }

    public void resetRow() {
        for (int i = 0; i < this.columns(); ++i) {
            ((TupleColumn)this.tupleColumns.get(i)).resetRow();
        }
        Enumeration keys = this.columnCounters.keys();
        while (keys.hasMoreElements()) {
            String folderName = (String)keys.nextElement();
            Tuple folder = this.getFolder(this.columnIndexByName(folderName), this.filledRows);
            folder.resetRows(folder.rows());
            TupleColumn tc = (TupleColumn)this.columnCounters.get(folder.name());
            tc.resetRow();
        }
    }

    public void reset() {
        for (int i = 0; i < this.columns(); ++i) {
            ((TupleColumn)this.tupleColumns.get(i)).reset();
        }
        this.filledRows = 0;
    }

    public int rows() {
        if (this.endRow != -1) {
            return this.endRow - this.startRow;
        }
        return this.filledRows - this.startRow;
    }

    public void close() {
    }

    public FTupleCursor cursor() throws IllegalStateException {
        return new Cursor(this);
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public String title() {
        return this.title;
    }

    public String name() {
        return this.name;
    }

    public int startRow() {
        return this.startRow;
    }

    protected void setStartEndRow(int startRow, int endRow) {
        this.startRow = startRow;
        this.endRow = endRow;
    }

    public void resetRows(int numberOfRows) {
        for (int i = 0; i < this.columns(); ++i) {
            ((TupleColumn)this.tupleColumns.get(i)).resetRows(numberOfRows);
        }
        int cf = this.filledRows;
        this.filledRows -= numberOfRows;
        Enumeration keys = this.columnCounters.keys();
        while (keys.hasMoreElements()) {
            String folderName = (String)keys.nextElement();
            while (numberOfRows-- > 0) {
                Tuple folder = this.getFolder(this.columnIndexByName(folderName), --cf);
                TupleColumn tc = (TupleColumn)this.columnCounters.get(folder.name());
                tc.value(numberOfRows, this.tupleValue);
                int end = this.tupleValue.getInt();
                int start = 0;
                if (numberOfRows > 0) {
                    tc.value(numberOfRows - 1, this.tupleValue);
                    start = this.tupleValue.getInt();
                }
                folder.setStartEndRow(start, end);
                folder.resetRows(folder.rows());
                tc.resetRows(1);
            }
        }
    }

    public FTuple tuple(int index) {
        return this.getFolder(index, this.filledRows);
    }

    protected Tuple getFolder(int index, int cursor) {
        Tuple tup = (Tuple)((TupleColumn)this.tupleColumns.get(index)).getDefaultValue().getObject();
        TupleColumn tc = (TupleColumn)this.columnCounters.get(tup.name());
        if (cursor > -1 && cursor < this.filledRows) {
            tc.value(cursor, this.tupleValue);
            int end = this.tupleValue.getInt();
            int start = 0;
            if (cursor > 0) {
                tc.value(cursor - 1, this.tupleValue);
                start = this.tupleValue.getInt();
            }
            tup.setStartEndRow(start, end);
        } else if (cursor == this.filledRows && cursor > 0) {
            tc.value(cursor - 1, this.tupleValue);
            int start = this.tupleValue.getInt();
            tup.setStartEndRow(start, -1);
        }
        return tup;
    }

    public void columnValue(int column, FTupleCursor cursor, Value value) {
        if (this.columnType(column) != FillableTuple.class) {
            ((TupleColumn)this.column(column)).value(cursor, value);
        } else {
            value.set((Object)this.getFolder(column, cursor.row()));
        }
    }

    public void fill(int column, Value value) {
        ((TupleColumn)this.column(column)).fill(value);
    }

    public void addTuple(FillableTuple tuple) {
        this.columnCounters.put(((Tuple)tuple).name(), new TupleColumnInt(((Tuple)tuple).name(), new Value().set(0), "length=1000; maxlength=-1"));
        this.addColumn(new TupleColumnFolder(((Tuple)tuple).name(), tuple, ""));
        this.folderList.add(tuple);
    }

    public void removeTuple(FillableTuple tuple) {
        String name = ((Tuple)tuple).name();
        this.columnCounters.remove(name);
        FTupleColumn col = this.columnByName(name);
        this.removeColumn((FillableTupleColumn)col);
        this.folderList.remove(tuple);
    }

    public boolean isInMemory() {
        return true;
    }
}

