/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.TupleColumn;
import org.freehep.util.Value;

public class TupleColumnLong
extends TupleColumn {
    private long[] data;

    TupleColumnLong(String name, Value value, String options) {
        super(name, Long.TYPE, value, options);
    }

    protected void createArray(int size) {
        long[] data = new long[size];
        if (this.hasDefaultValue()) {
            for (int i = 0; i < size; ++i) {
                data[i] = this.getDefaultValue().getLong();
            }
        }
        this.arrayList.add(data);
    }

    public void value(int index, Value value) {
        this.setCurrentArray(index);
        value.set(this.data[index % this.arraySize]);
    }

    public void setValue(int index, Value value) {
        try {
            this.setCurrentArray(index);
            this.data[index % this.arraySize] = value.getLong();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Wrong argument for TupleColumnLong");
        }
    }

    protected boolean hasStatistics() {
        return true;
    }

    public void defaultValue(Value value) {
        if (this.hasDefaultValue()) {
            value.set(this.getDefaultValue().getLong());
        }
    }

    protected void currentArrayUpdated() {
        this.data = (long[])this.currentArray;
    }
}

