/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.Tuple;
import hep.tuple.TupleColumnBoolean;
import hep.tuple.TupleColumnByte;
import hep.tuple.TupleColumnChar;
import hep.tuple.TupleColumnDate;
import hep.tuple.TupleColumnDouble;
import hep.tuple.TupleColumnFloat;
import hep.tuple.TupleColumnInt;
import hep.tuple.TupleColumnLong;
import hep.tuple.TupleColumnObject;
import hep.tuple.TupleColumnShort;
import hep.tuple.TupleColumnString;
import hep.tuple.interfaces.FTuple;
import hep.tuple.interfaces.FTupleCursor;
import hep.tuple.interfaces.FTupleFactory;
import hep.tuple.interfaces.FillableTuple;
import hep.tuple.interfaces.FillableTupleColumn;
import java.util.Date;
import org.freehep.util.Value;

public class TupleFactory
implements FTupleFactory {
    public FillableTuple createFTuple(String name, String title) {
        return this.createFTuple(name, title, "");
    }

    public FillableTuple createFTuple(String name, String title, String options) {
        return new Tuple(name, title, options);
    }

    public FillableTupleColumn createFTupleColumn(String name, Class type, Value value) {
        return this.createFTupleColumn(name, type, value, "");
    }

    public FillableTupleColumn createFTupleColumn(String name, Class type, Value value, String options) {
        if (type == Integer.TYPE) {
            return new TupleColumnInt(name, value, options);
        }
        if (type == Short.TYPE) {
            return new TupleColumnShort(name, value, options);
        }
        if (type == Long.TYPE) {
            return new TupleColumnLong(name, value, options);
        }
        if (type == Float.TYPE) {
            return new TupleColumnFloat(name, value, options);
        }
        if (type == Double.TYPE) {
            return new TupleColumnDouble(name, value, options);
        }
        if (type == Boolean.TYPE) {
            return new TupleColumnBoolean(name, value, options);
        }
        if (type == Byte.TYPE) {
            return new TupleColumnByte(name, value, options);
        }
        if (type == Character.TYPE) {
            return new TupleColumnChar(name, value, options);
        }
        if (type == String.class) {
            return new TupleColumnString(name, value, options);
        }
        if (type == Date.class) {
            return new TupleColumnDate(name, value, options);
        }
        return new TupleColumnObject(name, type, value, options);
    }

    public FTuple createInMemoryTuple(FTuple tuple) {
        Tuple newTuple = new Tuple(tuple.name(), tuple.title());
        Value value = new Value();
        int nColumns = tuple.columns();
        String[] columnNames = new String[nColumns];
        Class[] columnTypes = new Class[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            columnNames[i] = tuple.columnName(i);
            columnTypes[i] = tuple.columnType(i);
            if (tuple.column(i).hasDefaultValue()) {
                tuple.column(i).defaultValue(value);
                newTuple.addColumn(this.createFTupleColumn(columnNames[i], columnTypes[i], value));
                continue;
            }
            newTuple.addColumn(this.createFTupleColumn(columnNames[i], columnTypes[i], null));
        }
        FTupleCursor cursor = tuple.cursor();
        cursor.start();
        while (cursor.next()) {
            for (int i = 0; i < nColumns; ++i) {
                tuple.columnValue(i, cursor, value);
                newTuple.fill(i, value);
            }
            newTuple.addRow();
        }
        return newTuple;
    }
}

