/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.ComponentNodeTraverser;
import jas.hist.DataAreaNodeTraverser;
import jas.hist.JASHist;
import jas.hist.LegendNodeTraverser;
import jas.hist.StatsNodeTraverser;
import jas.hist.TitleNodeTraverser;
import jas.plot.Title;
import jas.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class JASHistNodeTraverser
extends ComponentNodeTraverser {
    private static TitleNodeTraverser tt = new TitleNodeTraverser();
    private static StatsNodeTraverser st = new StatsNodeTraverser();
    private static DataAreaNodeTraverser dt = new DataAreaNodeTraverser();
    private static LegendNodeTraverser lt = new LegendNodeTraverser();
    private JASHist plot;

    JASHistNodeTraverser() {
    }

    void traverse(Node node, JASHist jASHist) throws XMLNodeTraverser.BadXMLException {
        this.plot = jASHist;
        super.traverse(node, jASHist);
        lt.applyLegendEntries();
    }

    protected void handleElement(Element element, String string) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("title")) {
            Title title = this.plot.getTitleObject();
            if (title == null) {
                title = new Title();
                this.plot.setTitleObject(title);
            }
            tt.traverse((Node)element, title);
        } else if (string.equals("stats")) {
            st.traverse((Node)element, this.plot.getStats());
            this.plot.setShowStatistics(true);
        } else if (string.equals("dataArea")) {
            dt.traverse(element, this.plot.getDataArea(), this.plot);
        } else if (string.equals("legend")) {
            lt.traverse(element, this.plot.getLegend(), this.plot);
        } else {
            super.handleElement(element, string);
        }
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("allowUserInteraction")) {
            this.plot.setAllowUserInteraction(this.toBoolean(string2));
        } else {
            super.handleAttributeNode(attr, string, string2);
        }
    }
}

