/*
 * Decompiled with CFR 0.152.
 */
package jas.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JDirectoryChooser
extends JComponent {
    private FileTreeModel model = new FileTreeModel();
    private JFileChooser foo = new JFileChooser();
    private JButton approve = new JButton("Select");
    private JButton cancel = new JButton("Cancel");
    private File currentDirectory = null;
    private JTree tree;
    private JDialog dialog;
    private int returnValue;
    public static int APPROVE_OPTION = 0;
    public static int CANCEL_OPTION = 1;
    private static File root = new File("root");
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;
    static /* synthetic */ Class class$java$awt$Window;

    public JDirectoryChooser() {
        this(FileSystemView.getFileSystemView());
    }

    public JDirectoryChooser(File file) {
        this();
        this.setCurrentDirectory(file);
    }

    public JDirectoryChooser(String string) {
        this();
        if (string != null) {
            this.setCurrentDirectory(new File(string));
        }
    }

    public JDirectoryChooser(File file, FileSystemView fileSystemView) {
        this(fileSystemView);
        this.setCurrentDirectory(file);
    }

    public JDirectoryChooser(String string, FileSystemView fileSystemView) {
        this(fileSystemView);
        this.setCurrentDirectory(new File(string));
    }

    public JDirectoryChooser(FileSystemView fileSystemView) {
        this.setup(fileSystemView);
        ButtonListener buttonListener = new ButtonListener();
        this.tree = new JTree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new FileRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(buttonListener);
        this.approve.addActionListener(buttonListener);
        this.cancel.addActionListener(buttonListener);
        this.approve.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.tree));
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.approve);
        jPanel.add(this.cancel);
        this.add((Component)jPanel, "South");
    }

    public void addNotify() {
        this.tree.setModel(this.model);
        this.makeCurrentDirectoryVisible();
        super.addNotify();
    }

    private void makeCurrentDirectoryVisible() {
        if (this.currentDirectory != null) {
            Object object;
            File file = this.currentDirectory;
            FileSystemView fileSystemView = this.foo.getFileSystemView();
            Vector<File> vector = new Vector<File>();
            while (true) {
                if (file == null) {
                    return;
                }
                vector.addElement(file);
                if (fileSystemView.isRoot(file)) break;
                file = fileSystemView.getParentDirectory(file);
            }
            Object[] objectArray = new File[vector.size() + 1];
            objectArray[0] = object = this.model.getRoot();
            for (int i = 1; i < objectArray.length; ++i) {
                File file2 = (File)vector.elementAt(objectArray.length - i - 1);
                int n = this.model.getIndexOfChild(object, file2);
                if (n < 0) {
                    return;
                }
                objectArray[i] = object = this.model.getChild(object, n);
            }
            TreePath treePath = new TreePath(objectArray);
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.foo.setFileFilter(fileFilter);
        this.model.changed();
    }

    public FileFilter getFileFilter() {
        return this.foo.getFileFilter();
    }

    public void setFileHidingEnabled(boolean bl) {
        this.foo.setFileHidingEnabled(bl);
        this.model.changed();
    }

    public boolean isFileHidingEnabled() {
        return this.foo.isFileHidingEnabled();
    }

    public void setFileSelectionMode(int n) {
        this.foo.setFileSelectionMode(n);
        this.model.changed();
    }

    public int getFileSelectionMode() {
        return this.foo.getFileSelectionMode();
    }

    public void setMultiSelectionEnabled(boolean bl) {
        this.foo.setMultiSelectionEnabled(bl);
        this.tree.getSelectionModel().setSelectionMode(bl ? 4 : 1);
    }

    public boolean isMultiSelectionEnabled() {
        return this.foo.isMultiSelectionEnabled();
    }

    public File getSelectedFile() {
        return (File)this.tree.getLastSelectedPathComponent();
    }

    public File[] getSelectedFiles() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        File[] fileArray = new File[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            fileArray[i] = (File)treePathArray[i].getLastPathComponent();
        }
        return fileArray;
    }

    protected void setup(FileSystemView fileSystemView) {
        this.foo.setFileSystemView(fileSystemView);
    }

    public void updateUI() {
        super.updateUI();
        this.foo.updateUI();
    }

    public int showDialog(Component component) {
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JDirectoryChooser.class$("java.awt.Frame")) : class$java$awt$Frame, component);
        String string = null;
        string = this.foo.getDialogTitle();
        if (string == null) {
            this.foo.getUI().getDialogTitle(this.foo);
        }
        this.returnValue = 1;
        this.dialog = new JDialog(frame, string, true);
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(component);
        this.dialog.show();
        return this.returnValue;
    }

    public void setDialogTitle(String string) {
        this.foo.setDialogTitle(string);
    }

    public String getDialogTitle() {
        return this.foo.getDialogTitle();
    }

    public void setFileView(FileView fileView) {
        this.foo.setFileView(fileView);
    }

    public FileView getFileView() {
        return this.foo.getFileView();
    }

    public static void main(String[] stringArray) {
        final JTextField jTextField = new JTextField(40);
        JButton jButton = new JButton("Show Browser"){

            public void fireActionPerformed(ActionEvent actionEvent) {
                JDirectoryChooser jDirectoryChooser = new JDirectoryChooser(jTextField.getText());
                jDirectoryChooser.showDialog(this);
                if (jDirectoryChooser.getSelectedFile() != null) {
                    jTextField.setText(jDirectoryChooser.getSelectedFile().toString());
                }
            }
        };
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)jButton, "Center");
        jFrame.getContentPane().add((Component)jTextField, "South");
        jFrame.pack();
        jFrame.show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FileTreeModel
    implements TreeModel {
        private EventListenerList listenerList = new EventListenerList();
        private final int CACHE_SIZE = 10;
        private File[] cachedNode = new File[10];
        private File[][] cachedChildren = new File[10][];
        private int nextCache = 0;

        private FileTreeModel() {
        }

        public Object getChild(Object object, int n) {
            return this.children(object)[n];
        }

        public int getChildCount(Object object) {
            return this.children(object).length;
        }

        public int getIndexOfChild(Object object, Object object2) {
            File[] fileArray = this.children(object);
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].equals(object2)) continue;
                return i;
            }
            return -1;
        }

        public Object getRoot() {
            return root;
        }

        public boolean isLeaf(Object object) {
            return object != root && !((File)object).isDirectory();
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = JDirectoryChooser.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = JDirectoryChooser.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File[] children(Object object) {
            for (int i = 0; i < 10; ++i) {
                if (object != this.cachedNode[i]) continue;
                return this.cachedChildren[i];
            }
            Window window = null;
            Cursor cursor = null;
            if (JDirectoryChooser.this.tree != null && JDirectoryChooser.this.tree.isVisible() && (window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = JDirectoryChooser.class$("java.awt.Window")) : class$java$awt$Window, JDirectoryChooser.this.tree)) != null) {
                cursor = window.getCursor();
                window.setCursor(Cursor.getPredefinedCursor(3));
            }
            try {
                Object[] objectArray;
                FileSystemView fileSystemView = JDirectoryChooser.this.foo.getFileSystemView();
                File file = (File)object;
                boolean bl = file == root;
                Object[] objectArray2 = objectArray = bl ? fileSystemView.getRoots() : fileSystemView.getFiles(file, JDirectoryChooser.this.foo.isFileHidingEnabled());
                if (!bl) {
                    boolean bl2;
                    int n = JDirectoryChooser.this.foo.getFileSelectionMode();
                    JDirectoryChooser.this.foo;
                    boolean bl3 = bl2 = n == 1;
                    if (JDirectoryChooser.this.foo.getFileFilter() != null || bl2) {
                        Vector<Object> vector = new Vector<Object>();
                        for (int i = 0; i < objectArray.length; ++i) {
                            File file2 = objectArray[i];
                            if (bl2 && !file2.isDirectory() || !JDirectoryChooser.this.foo.accept(file2)) continue;
                            vector.addElement(objectArray[i]);
                        }
                        if (vector.size() != objectArray.length) {
                            objectArray = new File[vector.size()];
                            vector.copyInto(objectArray);
                        }
                    }
                }
                this.cachedNode[this.nextCache] = file;
                this.cachedChildren[this.nextCache] = objectArray;
                this.nextCache = (this.nextCache + 1) % 10;
                Object[] objectArray3 = objectArray;
                if (window != null) {
                    window.setCursor(cursor);
                }
                return objectArray3;
            }
            catch (Throwable throwable) {
                if (window != null) {
                    window.setCursor(cursor);
                }
                throw throwable;
            }
        }

        void changed() {
            this.cachedNode = new File[10];
            this.cachedChildren = new File[10][];
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(root)));
        }

        protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$TreeModelListener == null ? JDirectoryChooser.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
            }
        }
    }

    private class FileRenderer
    extends DefaultTreeCellRenderer {
        private FileRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel && object instanceof File) {
                JLabel jLabel = (JLabel)component;
                File file = (File)object;
                jLabel.setText(JDirectoryChooser.this.foo.getName(file));
                jLabel.setIcon(JDirectoryChooser.this.foo.getIcon(file));
            }
            return component;
        }
    }

    private class ButtonListener
    implements ActionListener,
    TreeSelectionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == JDirectoryChooser.this.approve) {
                JDirectoryChooser.this.foo;
                JDirectoryChooser.this.returnValue = 0;
            }
            JDirectoryChooser.this.dialog.hide();
            JDirectoryChooser.this.dialog = null;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            JDirectoryChooser.this.approve.setEnabled(JDirectoryChooser.this.tree.getSelectionCount() > 0);
        }
    }
}

